|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *address* | The AMQP address. If not set, the channel name is used | string | false |  |
| *auto-acknowledgement* | Whether the received AMQP messages must be acknowledged when received | boolean | false | `false` |
| *broadcast* | Whether the received AMQP messages must be dispatched to multiple _subscribers_ | boolean | false | `false` |
| *capabilities* | A comma-separated list of capabilities proposed by the sender or receiver client. | string | false |  |
| *client-options-name* _(amqp-client-options-name)_ | The name of the AMQP Client Option bean used to customize the AMQP client configuration | string | false |  |
| *cloud-events* | Enables (default) or disables the Cloud Event support. If enabled on an _incoming_ channel, the connector analyzes the incoming records and try to create Cloud Event metadata. If enabled on an _outgoing_, the connector sends the outgoing messages as Cloud Event if the message includes Cloud Event Metadata. | boolean | false | `true` |
| *connect-timeout* _(amqp-connect-timeout)_ | The connection timeout in milliseconds | int | false | `1000` |
| *container-id* | The AMQP container id | string | false |  |
| *durable* | Whether AMQP subscription is durable | boolean | false | `false` |
| *failure-strategy* | Specify the failure strategy to apply when a message produced from an AMQP message is nacked. Accepted values are `fail` (default), `accept`, `release`, `reject`, `modified-failed`, `modified-failed-undeliverable-here` | string | false | `fail` |
| *health-timeout* | The max number of seconds to wait to determine if the connection with the broker is still established for the readiness check. After that threshold, the check is considered as failed. | int | false | `3` |
| *host* _(amqp-host)_ | The broker hostname | string | false | `localhost` |
| *link-name* | The name of the link. If not set, the channel name is used. | string | false |  |
| *password* _(amqp-password)_ | The password used to authenticate to the broker | string | false |  |
| *port* _(amqp-port)_ | The broker port | int | false | `5672` |
| *reconnect-attempts* _(amqp-reconnect-attempts)_ | The number of reconnection attempts | int | false | `100` |
| *reconnect-interval* _(amqp-reconnect-interval)_ | The interval in second between two reconnection attempts | int | false | `10` |
| *selector* | Sets a message selector. This attribute is used to define an `apache.org:selector-filter:string` filter on the source terminus, using SQL-based syntax to request the server filters which messages are delivered to the receiver (if supported by the server in question). Precise functionality supported and syntax needed can vary depending on the server. | string | false |  |
| *sni-server-name* _(amqp-sni-server-name)_ | If set, explicitly override the hostname to use for the TLS SNI server name | string | false |  |
| *tracing-enabled* | Whether tracing is enabled (default) or disabled | boolean | false | `true` |
| *use-ssl* _(amqp-use-ssl)_ | Whether the AMQP connection uses SSL/TLS | boolean | false | `false` |
| *username* _(amqp-username)_ | The username used to authenticate to the broker | string | false |  |
| *virtual-host* _(amqp-virtual-host)_ | If set, configure the hostname value used for the connection AMQP Open frame and TLS SNI server name (if TLS is in use) | string | false |  |
