/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import io.smallrye.reactive.messaging.pulsar.PulsarConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class PulsarConnectorIncomingConfiguration
extends PulsarConnectorCommonConfiguration {
    public PulsarConnectorIncomingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public Optional<String> getConsumerConfiguration() {
        return this.config.getOptionalValue("consumer-configuration", String.class);
    }

    public String getAckStrategy() {
        return this.config.getOptionalValue("ack-strategy", String.class).orElse("ack");
    }

    public String getFailureStrategy() {
        return this.config.getOptionalValue("failure-strategy", String.class).orElse("nack");
    }

    public Long getReconsumeLaterDelay() {
        return this.config.getOptionalValue("reconsumeLater.delay", Long.class).orElse(Long.valueOf("3"));
    }

    public Optional<String> getNegativeAckRedeliveryBackoff() {
        return this.config.getOptionalValue("negativeAck.redeliveryBackoff", String.class);
    }

    public Optional<String> getAckTimeoutRedeliveryBackoff() {
        return this.config.getOptionalValue("ackTimeout.redeliveryBackoff", String.class);
    }

    public Optional<Integer> getDeadLetterPolicyMaxRedeliverCount() {
        return this.config.getOptionalValue("deadLetterPolicy.maxRedeliverCount", Integer.class);
    }

    public Optional<String> getDeadLetterPolicyDeadLetterTopic() {
        return this.config.getOptionalValue("deadLetterPolicy.deadLetterTopic", String.class);
    }

    public Optional<String> getDeadLetterPolicyRetryLetterTopic() {
        return this.config.getOptionalValue("deadLetterPolicy.retryLetterTopic", String.class);
    }

    public Optional<String> getDeadLetterPolicyInitialSubscriptionName() {
        return this.config.getOptionalValue("deadLetterPolicy.initialSubscriptionName", String.class);
    }

    public Boolean getBatchReceive() {
        return this.config.getOptionalValue("batchReceive", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    @Override
    public void validate() {
        super.validate();
    }
}

