/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.converters;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessageMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.schema.GenericRecord;

@ApplicationScoped
public class GenericRecordConverter
implements MessageConverter {
    public boolean canConvert(org.eclipse.microprofile.reactive.messaging.Message<?> in, Type target) {
        return in.getMetadata(PulsarIncomingMessageMetadata.class).isPresent() && TypeUtils.isAssignable((Type)target, GenericRecord.class);
    }

    public org.eclipse.microprofile.reactive.messaging.Message<?> convert(org.eclipse.microprofile.reactive.messaging.Message<?> in, Type target) {
        PulsarIncomingMessageMetadata metadata = (PulsarIncomingMessageMetadata)in.getMetadata(PulsarIncomingMessageMetadata.class).orElseThrow(() -> new IllegalStateException("No Pulsar metadata"));
        Message<?> message = metadata.getMessage();
        return in.withPayload(message.getValue());
    }
}

