/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class DirConfigSource
implements ConfigSource {
    private static final Logger LOG = Logger.getLogger((String)"io.smallrye.config");
    private static final String CONFIG_ORDINAL_KEY = "config_ordinal";
    private static final String CONFIG_ORDINAL_DEFAULT_VALUE = "100";
    private final File dir;
    private final int ordinal;
    private final Map<String, String> props;

    DirConfigSource(File dir) {
        this(dir, 100);
    }

    public DirConfigSource(File dir, int ordinal) {
        this.dir = dir;
        this.props = this.scan();
        this.ordinal = this.props.containsKey(CONFIG_ORDINAL_KEY) ? Integer.valueOf(this.props.getOrDefault(CONFIG_ORDINAL_KEY, CONFIG_ORDINAL_DEFAULT_VALUE)) : ordinal;
    }

    private Map<String, String> scan() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.dir == null || !this.dir.isDirectory()) {
            return props;
        }
        for (File file : this.dir.listFiles()) {
            if (file.isDirectory()) continue;
            try {
                String key = file.getName();
                String value = this.readContent(file);
                props.put(key, value);
            }
            catch (Throwable t) {
                LOG.warnf("Unable to read content from file %s", (Object)file.getAbsolutePath());
            }
        }
        return props;
    }

    private String readContent(File file) throws IOException {
        try (Stream<String> stream = Files.lines(file.toPath());){
            String string = stream.collect(Collectors.joining());
            return string;
        }
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public String getValue(String key) {
        return this.props.get(key);
    }

    public String getName() {
        return "DirConfigSource[dir=" + this.dir.getAbsolutePath() + "]";
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

