/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.faulttolerance.BeforeRetryHandlerProvider;
import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.ExecutionContextImpl;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.RequestContextIntegration;
import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.api.AlwaysOnException;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.api.NeverOnResult;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.FailureContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.apiimpl.LazyFaultTolerance;
import io.smallrye.faulttolerance.core.async.CompletionStageExecution;
import io.smallrye.faulttolerance.core.async.FutureExecution;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.bulkhead.CompletionStageThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.FutureThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.SemaphoreBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CompletionStageCircuitBreaker;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.fallback.AsyncFallbackFunction;
import io.smallrye.faulttolerance.core.fallback.CompletionStageFallback;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.invocation.AsyncSupport;
import io.smallrye.faulttolerance.core.invocation.AsyncSupportRegistry;
import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.invocation.StrategyInvoker;
import io.smallrye.faulttolerance.core.metrics.CompletionStageMetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.rate.limit.CompletionStageRateLimit;
import io.smallrye.faulttolerance.core.rate.limit.RateLimit;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.CompletionStageRetry;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.AsyncTimeout;
import io.smallrye.faulttolerance.core.timeout.CompletionStageTimeout;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.DirectExecutor;
import io.smallrye.faulttolerance.core.util.Durations;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.PredicateBasedResultDecision;
import io.smallrye.faulttolerance.core.util.ResultDecision;
import io.smallrye.faulttolerance.core.util.SetBasedExceptionDecision;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import io.smallrye.faulttolerance.internal.BeforeRetryMethod;
import io.smallrye.faulttolerance.internal.FallbackMethod;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import io.smallrye.faulttolerance.internal.InterceptionInvoker;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.RequestScopeActivator;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.CdiMeteredOperationImpl;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.control.RequestContextController;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@Interceptor
@FaultToleranceBinding
@Priority(value=4010)
public class FaultToleranceInterceptor {
    private final Bean<?> interceptedBean;
    private final FaultToleranceOperationProvider operationProvider;
    private final StrategyCache cache;
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final BeforeRetryHandlerProvider beforeRetryHandlerProvider;
    private final MetricsProvider metricsProvider;
    private final ExecutorService asyncExecutor;
    private final EventLoop eventLoop;
    private final Timer timer;
    private final RequestContextController requestContextController;
    private final CircuitBreakerMaintenanceImpl cbMaintenance;
    private final SpecCompatibility specCompatibility;
    private final Instance<FaultTolerance<?>> configuredFaultTolerance;

    @Inject
    public FaultToleranceInterceptor(@Intercepted Bean<?> interceptedBean, FaultToleranceOperationProvider operationProvider, StrategyCache cache, FallbackHandlerProvider fallbackHandlerProvider, BeforeRetryHandlerProvider beforeRetryHandlerProvider, MetricsProvider metricsProvider, ExecutorHolder executorHolder, RequestContextIntegration requestContextIntegration, CircuitBreakerMaintenanceImpl cbMaintenance, SpecCompatibility specCompatibility, @Any Instance<FaultTolerance<?>> configuredFaultTolerance) {
        this.interceptedBean = interceptedBean;
        this.operationProvider = operationProvider;
        this.cache = cache;
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.beforeRetryHandlerProvider = beforeRetryHandlerProvider;
        this.metricsProvider = metricsProvider;
        this.asyncExecutor = executorHolder.getAsyncExecutor();
        this.eventLoop = executorHolder.getEventLoop();
        this.timer = executorHolder.getTimer();
        this.requestContextController = requestContextIntegration.get();
        this.cbMaintenance = cbMaintenance;
        this.specCompatibility = specCompatibility;
        this.configuredFaultTolerance = configuredFaultTolerance;
    }

    @AroundInvoke
    public Object intercept(jakarta.interceptor.InvocationContext interceptionContext) throws Exception {
        Method method = interceptionContext.getMethod();
        Class beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : method.getDeclaringClass();
        InterceptionPoint point = new InterceptionPoint(beanClass, interceptionContext.getMethod());
        FaultToleranceOperation operation = this.operationProvider.get(beanClass, method);
        if (operation.hasApplyFaultTolerance()) {
            return this.preconfiguredFlow(operation, interceptionContext);
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation)) {
            return this.asyncFlow(operation, interceptionContext, point);
        }
        if (this.specCompatibility.isOperationPseudoAsynchronous(operation)) {
            return this.futureFlow(operation, interceptionContext, point);
        }
        return this.syncFlow(operation, interceptionContext, point);
    }

    private Object preconfiguredFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext) throws Exception {
        AsyncSupport fromConfigured;
        String identifier = operation.getApplyFaultTolerance().value();
        Instance instance = this.configuredFaultTolerance.select(new Annotation[]{Identifier.Literal.of((String)identifier)});
        if (!instance.isResolvable()) {
            throw new FaultToleranceException("Can't resolve a bean of type " + FaultTolerance.class.getName() + " with qualifier @" + Identifier.class.getName() + "(\"" + identifier + "\")");
        }
        FaultTolerance faultTolerance = (FaultTolerance)instance.get();
        if (!(faultTolerance instanceof LazyFaultTolerance)) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' is not created by the FaultTolerance API, this is not supported");
        }
        Class asyncType = ((LazyFaultTolerance)faultTolerance).internalGetAsyncType();
        AsyncSupport forOperation = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        AsyncSupport asyncSupport = fromConfigured = asyncType == null ? null : AsyncSupportRegistry.get((Class[])new Class[0], (Class)asyncType);
        if (forOperation == null && fromConfigured == null) {
            return faultTolerance.call(() -> ((jakarta.interceptor.InvocationContext)interceptionContext).proceed());
        }
        if (forOperation == null) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to " + fromConfigured.mustDescription() + ", but the operation is synchronous: " + operation);
        }
        if (fromConfigured == null) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to be synchronous, but it " + forOperation.doesDescription() + ": " + operation);
        }
        if (!forOperation.getClass().equals(fromConfigured.getClass())) {
            throw new FaultToleranceException("Configured fault tolerance '" + identifier + "' expects the operation to " + fromConfigured.mustDescription() + ", but it " + forOperation.doesDescription() + ": " + operation);
        }
        return faultTolerance.call(() -> ((jakarta.interceptor.InvocationContext)interceptionContext).proceed());
    }

    private <V, AT> AT asyncFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext, InterceptionPoint point) {
        AsyncSupport asyncSupport = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        if (asyncSupport == null) {
            throw new FaultToleranceException("Unknown async invocation: " + operation);
        }
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareAsyncStrategy(operation, point));
        InterceptionInvoker invoker = new InterceptionInvoker(interceptionContext);
        InvocationContext<CompletionStage> ctx = this.invocationContext(() -> asyncSupport.toCompletionStage(invoker), interceptionContext, operation);
        StrategyInvoker wrapper = new StrategyInvoker(interceptionContext.getParameters(), strategy, ctx);
        try {
            return (AT)asyncSupport.fromCompletionStage((Invoker)wrapper);
        }
        catch (Exception e) {
            throw SneakyThrow.sneakyThrow((Throwable)e);
        }
    }

    private <T> T syncFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareSyncStrategy(operation, point));
        InvocationContext<Object> ctx = this.invocationContext(() -> interceptionContext.proceed(), interceptionContext, operation);
        return (T)strategy.apply(ctx);
    }

    private <T> Future<T> futureFlow(FaultToleranceOperation operation, jakarta.interceptor.InvocationContext interceptionContext, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, () -> this.prepareFutureStrategy(operation, point));
        InvocationContext<Future> ctx = this.invocationContext(() -> (Future)interceptionContext.proceed(), interceptionContext, operation);
        return (Future)strategy.apply(ctx);
    }

    private <T> InvocationContext<T> invocationContext(Callable<T> callable, jakarta.interceptor.InvocationContext interceptionContext, FaultToleranceOperation operation) {
        InvocationContext result = new InvocationContext(callable);
        result.set(jakarta.interceptor.InvocationContext.class, (Object)interceptionContext);
        if (operation.hasCircuitBreaker() && operation.hasCircuitBreakerName()) {
            result.registerEventHandler(CircuitBreakerEvents.StateTransition.class, this.cbMaintenance.stateTransitionEventHandler(operation.getCircuitBreakerName().value()));
        }
        return result;
    }

    private <T> FaultToleranceStrategy<CompletionStage<T>> prepareAsyncStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        Object executor = operation.isThreadOffloadRequired() ? this.asyncExecutor : DirectExecutor.INSTANCE;
        result = new CompletionStageExecution((FaultToleranceStrategy)result, (Executor)executor);
        if (operation.hasBulkhead()) {
            int size = operation.getBulkhead().value();
            int queueSize = operation.getBulkhead().waitingTaskQueue();
            result = new CompletionStageThreadPoolBulkhead((FaultToleranceStrategy)result, point.toString(), size, queueSize);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = Durations.timeInMillis((long)operation.getTimeout().value(), (ChronoUnit)operation.getTimeout().unit());
            result = new CompletionStageTimeout((FaultToleranceStrategy)result, point.toString(), timeoutMs, this.timer);
        }
        if (operation.hasRateLimit()) {
            result = new CompletionStageRateLimit((FaultToleranceStrategy)result, point.toString(), operation.getRateLimit().value(), Durations.timeInMillis((long)operation.getRateLimit().window(), (ChronoUnit)operation.getRateLimit().windowUnit()), Durations.timeInMillis((long)operation.getRateLimit().minSpacing(), (ChronoUnit)operation.getRateLimit().minSpacingUnit()), operation.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
        }
        if (operation.hasCircuitBreaker()) {
            long delayInMillis = Durations.timeInMillis((long)operation.getCircuitBreaker().delay(), (ChronoUnit)operation.getCircuitBreaker().delayUnit());
            result = new CompletionStageCircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), delayInMillis, operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, this.timer);
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            long maxDurationMs = Durations.timeInMillis((long)operation.getRetry().maxDuration(), (ChronoUnit)operation.getRetry().durationUnit());
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new CompletionStageRetry((FaultToleranceStrategy)result, point.toString(), this.createResultDecision(operation.hasRetryWhen() ? operation.getRetryWhen().result() : null), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn(), operation.hasRetryWhen() ? operation.getRetryWhen().exception() : null), (long)operation.getRetry().maxRetries(), maxDurationMs, () -> new TimerDelay((BackOff)backoff.get(), this.timer), (Stopwatch)SystemStopwatch.INSTANCE, operation.hasBeforeRetry() ? this.prepareBeforeRetryFunction(point, operation) : null);
        }
        if (operation.hasFallback()) {
            result = new CompletionStageFallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            CdiMeteredOperationImpl meteredOperation = new CdiMeteredOperationImpl(operation, point, this.specCompatibility);
            result = new CompletionStageMetricsCollector((FaultToleranceStrategy)result, this.metricsProvider.create((MeteredOperation)meteredOperation), (MeteredOperation)meteredOperation);
        }
        if (!operation.isThreadOffloadRequired()) {
            result = new RememberEventLoop((FaultToleranceStrategy)result, this.eventLoop);
        }
        return result;
    }

    private <T> FaultToleranceStrategy<T> prepareSyncStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Invocation result = Invocation.invocation();
        if (operation.hasBulkhead()) {
            result = new SemaphoreBulkhead((FaultToleranceStrategy)result, point.toString(), operation.getBulkhead().value());
        }
        if (operation.hasTimeout()) {
            long timeoutMs = Durations.timeInMillis((long)operation.getTimeout().value(), (ChronoUnit)operation.getTimeout().unit());
            result = new Timeout((FaultToleranceStrategy)result, point.toString(), timeoutMs, this.timer);
        }
        if (operation.hasRateLimit()) {
            result = new RateLimit((FaultToleranceStrategy)result, point.toString(), operation.getRateLimit().value(), Durations.timeInMillis((long)operation.getRateLimit().window(), (ChronoUnit)operation.getRateLimit().windowUnit()), Durations.timeInMillis((long)operation.getRateLimit().minSpacing(), (ChronoUnit)operation.getRateLimit().minSpacingUnit()), operation.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
        }
        if (operation.hasCircuitBreaker()) {
            long delayInMillis = Durations.timeInMillis((long)operation.getCircuitBreaker().delay(), (ChronoUnit)operation.getCircuitBreaker().delayUnit());
            result = new CircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), delayInMillis, operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, this.timer);
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            long maxDurationMs = Durations.timeInMillis((long)operation.getRetry().maxDuration(), (ChronoUnit)operation.getRetry().durationUnit());
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new Retry((FaultToleranceStrategy)result, point.toString(), this.createResultDecision(operation.hasRetryWhen() ? operation.getRetryWhen().result() : null), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn(), operation.hasRetryWhen() ? operation.getRetryWhen().exception() : null), (long)operation.getRetry().maxRetries(), maxDurationMs, () -> new ThreadSleepDelay((BackOff)backoff.get()), (Stopwatch)SystemStopwatch.INSTANCE, operation.hasBeforeRetry() ? this.prepareBeforeRetryFunction(point, operation) : null);
        }
        if (operation.hasFallback()) {
            result = new Fallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            CdiMeteredOperationImpl meteredOperation = new CdiMeteredOperationImpl(operation, point, this.specCompatibility);
            result = new MetricsCollector((FaultToleranceStrategy)result, this.metricsProvider.create((MeteredOperation)meteredOperation), (MeteredOperation)meteredOperation);
        }
        return result;
    }

    private <T> FaultToleranceStrategy<Future<T>> prepareFutureStrategy(FaultToleranceOperation operation, InterceptionPoint point) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        if (operation.hasBulkhead()) {
            int size = operation.getBulkhead().value();
            int queueSize = operation.getBulkhead().waitingTaskQueue();
            result = new FutureThreadPoolBulkhead((FaultToleranceStrategy)result, point.toString(), size, queueSize);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = Durations.timeInMillis((long)operation.getTimeout().value(), (ChronoUnit)operation.getTimeout().unit());
            Timeout timeout = new Timeout((FaultToleranceStrategy)result, point.toString(), timeoutMs, this.timer);
            result = new AsyncTimeout(timeout, (Executor)this.asyncExecutor);
        }
        if (operation.hasRateLimit()) {
            result = new RateLimit((FaultToleranceStrategy)result, point.toString(), operation.getRateLimit().value(), Durations.timeInMillis((long)operation.getRateLimit().window(), (ChronoUnit)operation.getRateLimit().windowUnit()), Durations.timeInMillis((long)operation.getRateLimit().minSpacing(), (ChronoUnit)operation.getRateLimit().minSpacingUnit()), operation.getRateLimit().type(), (Stopwatch)SystemStopwatch.INSTANCE);
        }
        if (operation.hasCircuitBreaker()) {
            long delayInMillis = Durations.timeInMillis((long)operation.getCircuitBreaker().delay(), (ChronoUnit)operation.getCircuitBreaker().delayUnit());
            result = new CircuitBreaker((FaultToleranceStrategy)result, point.toString(), this.createExceptionDecision(operation.getCircuitBreaker().skipOn(), operation.getCircuitBreaker().failOn()), delayInMillis, operation.getCircuitBreaker().requestVolumeThreshold(), operation.getCircuitBreaker().failureRatio(), operation.getCircuitBreaker().successThreshold(), (Stopwatch)SystemStopwatch.INSTANCE, this.timer);
            String cbName = operation.hasCircuitBreakerName() ? operation.getCircuitBreakerName().value() : UUID.randomUUID().toString();
            this.cbMaintenance.register(cbName, (CircuitBreaker)result);
        }
        if (operation.hasRetry()) {
            long maxDurationMs = Durations.timeInMillis((long)operation.getRetry().maxDuration(), (ChronoUnit)operation.getRetry().durationUnit());
            Supplier<BackOff> backoff = this.prepareRetryBackoff(operation);
            result = new Retry((FaultToleranceStrategy)result, point.toString(), this.createResultDecision(operation.hasRetryWhen() ? operation.getRetryWhen().result() : null), this.createExceptionDecision(operation.getRetry().abortOn(), operation.getRetry().retryOn(), operation.hasRetryWhen() ? operation.getRetryWhen().exception() : null), (long)operation.getRetry().maxRetries(), maxDurationMs, () -> new ThreadSleepDelay((BackOff)backoff.get()), (Stopwatch)SystemStopwatch.INSTANCE, operation.hasBeforeRetry() ? this.prepareBeforeRetryFunction(point, operation) : null);
        }
        if (operation.hasFallback()) {
            result = new Fallback((FaultToleranceStrategy)result, point.toString(), this.prepareFallbackFunction(point, operation), this.createExceptionDecision(operation.getFallback().skipOn(), operation.getFallback().applyOn()));
        }
        if (this.metricsProvider.isEnabled()) {
            CdiMeteredOperationImpl meteredOperation = new CdiMeteredOperationImpl(operation, point, this.specCompatibility);
            result = new MetricsCollector((FaultToleranceStrategy)result, this.metricsProvider.create((MeteredOperation)meteredOperation), (MeteredOperation)meteredOperation);
        }
        result = new FutureExecution((FaultToleranceStrategy)result, (Executor)this.asyncExecutor);
        return result;
    }

    private Supplier<BackOff> prepareRetryBackoff(FaultToleranceOperation operation) {
        Jitter jitter;
        long delayMs = Durations.timeInMillis((long)operation.getRetry().delay(), (ChronoUnit)operation.getRetry().delayUnit());
        long jitterMs = Durations.timeInMillis((long)operation.getRetry().jitter(), (ChronoUnit)operation.getRetry().jitterDelayUnit());
        Object object = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
        if (operation.hasExponentialBackoff()) {
            int factor = operation.getExponentialBackoff().factor();
            long maxDelay = Durations.timeInMillis((long)operation.getExponentialBackoff().maxDelay(), (ChronoUnit)operation.getExponentialBackoff().maxDelayUnit());
            return () -> new ExponentialBackOff(delayMs, factor, jitter, maxDelay);
        }
        if (operation.hasFibonacciBackoff()) {
            long maxDelay = Durations.timeInMillis((long)operation.getFibonacciBackoff().maxDelay(), (ChronoUnit)operation.getFibonacciBackoff().maxDelayUnit());
            return () -> new FibonacciBackOff(delayMs, jitter, maxDelay);
        }
        if (operation.hasCustomBackoff()) {
            Class strategy = operation.getCustomBackoff().value();
            return () -> {
                CustomBackoffStrategy instance;
                try {
                    instance = (CustomBackoffStrategy)strategy.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw SneakyThrow.sneakyThrow((Throwable)e);
                }
                instance.init(delayMs);
                return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
            };
        }
        return () -> new ConstantBackOff(delayMs, jitter);
    }

    private <V> Function<FailureContext, V> prepareFallbackFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        AsyncFallbackFunction fallbackFunction;
        FallbackMethodCandidates candidates;
        AsyncSupport asyncSupport = AsyncSupportRegistry.get((Class[])operation.getParameterTypes(), operation.getReturnType());
        String fallbackMethodName = operation.getFallback().fallbackMethod();
        FallbackMethodCandidates fallbackMethodCandidates = candidates = !"".equals(fallbackMethodName) ? this.cache.getFallbackMethodCandidates(point, fallbackMethodName) : null;
        if (candidates != null) {
            fallbackFunction = ctx -> {
                FallbackMethod fallbackMethod = candidates.select(ctx.failure.getClass());
                if (fallbackMethod == null) {
                    throw SneakyThrow.sneakyThrow((Throwable)ctx.failure);
                }
                try {
                    Invoker<?> invoker = fallbackMethod.createInvoker((FailureContext)ctx);
                    return asyncSupport == null ? invoker.proceed() : asyncSupport.toCompletionStage(invoker);
                }
                catch (InvocationTargetException e) {
                    throw SneakyThrow.sneakyThrow((Throwable)e.getCause());
                }
                catch (Throwable e) {
                    throw new FaultToleranceException("Error during fallback method invocation", e);
                }
            };
        } else {
            FallbackHandler fallbackHandler = this.fallbackHandlerProvider.get(operation);
            if (fallbackHandler != null) {
                fallbackFunction = ctx -> {
                    ExecutionContextImpl executionContext = new ExecutionContextImpl((jakarta.interceptor.InvocationContext)ctx.invocationContext.get(jakarta.interceptor.InvocationContext.class), ctx.failure);
                    Object result = fallbackHandler.handle((ExecutionContext)executionContext);
                    if (asyncSupport != null) {
                        result = asyncSupport.fallbackResultToCompletionStage(result);
                    }
                    return result;
                };
            } else {
                throw new FaultToleranceException("Could not obtain fallback handler for " + point);
            }
        }
        if (this.specCompatibility.isOperationTrulyAsynchronous(operation) && operation.isThreadOffloadRequired()) {
            fallbackFunction = new AsyncFallbackFunction(fallbackFunction, (Executor)this.asyncExecutor);
        }
        return fallbackFunction;
    }

    private Consumer<FailureContext> prepareBeforeRetryFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        Consumer<FailureContext> beforeRetryFunction;
        BeforeRetryMethod method;
        String methodName = operation.getBeforeRetry().methodName();
        BeforeRetryMethod beforeRetryMethod = method = !"".equals(methodName) ? this.cache.getBeforeRetryMethod(point, methodName) : null;
        if (method != null) {
            beforeRetryFunction = ctx -> {
                try {
                    method.createInvoker((FailureContext)ctx).proceed();
                }
                catch (InvocationTargetException e) {
                    throw SneakyThrow.sneakyThrow((Throwable)e.getCause());
                }
                catch (Throwable e) {
                    throw new FaultToleranceException("Error during before retry method invocation", e);
                }
            };
        } else {
            BeforeRetryHandler beforeRetryHandler = this.beforeRetryHandlerProvider.get(operation);
            if (beforeRetryHandler != null) {
                beforeRetryFunction = ctx -> {
                    ExecutionContextImpl executionContext = new ExecutionContextImpl((jakarta.interceptor.InvocationContext)ctx.invocationContext.get(jakarta.interceptor.InvocationContext.class), ctx.failure);
                    beforeRetryHandler.handle((ExecutionContext)executionContext);
                };
            } else {
                throw new FaultToleranceException("Could not obtain before retry handler for " + point);
            }
        }
        return beforeRetryFunction;
    }

    private ResultDecision createResultDecision(Class<? extends Predicate<Object>> whenResult) {
        if (whenResult != null && whenResult != NeverOnResult.class) {
            Predicate<Object> predicate;
            try {
                predicate = whenResult.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw SneakyThrow.sneakyThrow((Throwable)e);
            }
            return new PredicateBasedResultDecision(predicate.negate());
        }
        return ResultDecision.ALWAYS_EXPECTED;
    }

    private ExceptionDecision createExceptionDecision(Class<? extends Throwable>[] consideredExpected, Class<? extends Throwable>[] consideredFailure) {
        return new SetBasedExceptionDecision(this.createSetOfThrowables(consideredFailure), this.createSetOfThrowables(consideredExpected), this.specCompatibility.inspectExceptionCauseChain());
    }

    private ExceptionDecision createExceptionDecision(Class<? extends Throwable>[] consideredExpected, Class<? extends Throwable>[] consideredFailure, Class<? extends Predicate<Throwable>> whenException) {
        if (whenException != null && whenException != AlwaysOnException.class) {
            Predicate<Throwable> predicate;
            try {
                predicate = whenException.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw SneakyThrow.sneakyThrow((Throwable)e);
            }
            return new PredicateBasedExceptionDecision(predicate.negate());
        }
        return new SetBasedExceptionDecision(this.createSetOfThrowables(consideredFailure), this.createSetOfThrowables(consideredExpected), this.specCompatibility.inspectExceptionCauseChain());
    }

    private SetOfThrowables createSetOfThrowables(Class<? extends Throwable>[] throwableClasses) {
        if (throwableClasses == null || throwableClasses.length == 0) {
            return SetOfThrowables.EMPTY;
        }
        return SetOfThrowables.create(Arrays.asList(throwableClasses));
    }
}

