/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.metrics.MetricMeasurement;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.spi.MetricsService;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.jboss.logging.Logger;

public class MPMetricsService
implements MetricsService {
    private MetricRegistry metricRegistry;
    private final Map<Long, MetricMeasurement<Long>> metricsMemory = new ConcurrentHashMap<Long, MetricMeasurement<Long>>();
    private final Map<String, AtomicLong> subscriptions = new ConcurrentHashMap<String, AtomicLong>();
    private static final String METRIC_NAME = "mp_graphql";
    private static final String METRIC_SUBSCRIPTIONS = "mp_graphql_subscription";
    private Logger LOG = Logger.getLogger(MPMetricsService.class);

    public MPMetricsService() {
        this.getMetricRegistry();
    }

    private MetricRegistry getMetricRegistry() {
        if (this.metricRegistry == null) {
            this.metricRegistry = (MetricRegistry)CDI.current().select(MetricRegistry.class, new Annotation[]{new VendorType()}).get();
        }
        return this.metricRegistry;
    }

    private Tag[] getTags(MetricMeasurement<Long> metricMeasurement) {
        return new Tag[]{new Tag("name", metricMeasurement.getName()), new Tag("type", metricMeasurement.getOperationType()), new Tag("source", String.valueOf(metricMeasurement.isSource()))};
    }

    public void start(Long measurementId, Context context) {
        this.metricsMemory.put(measurementId, new MetricMeasurement<Long>(context.getFieldName(), context.hasSource(), context.getOperationType(), System.nanoTime()));
        this.LOG.tracef("(" + measurementId + ") Started recording metrics for: %s", (Object)context.getFieldName());
    }

    public void end(Long measurementId) {
        MetricMeasurement<Long> metricMeasurement = this.metricsMemory.remove(measurementId);
        long duration = System.nanoTime() - metricMeasurement.getMetric();
        this.getMetricRegistry().simpleTimer(METRIC_NAME, this.getTags(metricMeasurement)).update(Duration.ofNanos(duration));
        this.LOG.tracef("(" + measurementId + ") Finished recording metrics for: %s", (Object)metricMeasurement.getName());
    }

    public void subscriptionStart(Context context) {
        if (!OperationType.SUBSCRIPTION.name().equals(context.getOperationType())) {
            return;
        }
        this.subscriptions.computeIfAbsent(context.getFieldName(), k -> new AtomicLong(0L));
        this.subscriptions.get(context.getFieldName()).incrementAndGet();
        this.getMetricRegistry().gauge(METRIC_SUBSCRIPTIONS, () -> this.subscriptions.get(context.getFieldName()).get(), new Tag[]{new Tag("name", context.getFieldName())});
    }

    public void subscriptionEnd(Context context) {
        if (!OperationType.SUBSCRIPTION.name().equals(context.getOperationType())) {
            return;
        }
        Optional.ofNullable(this.subscriptions.get(context.getFieldName())).ifPresent(AtomicLong::decrementAndGet);
    }

    class VendorType
    extends AnnotationLiteral<RegistryType>
    implements RegistryType {
        VendorType() {
        }

        public MetricRegistry.Type type() {
            return MetricRegistry.Type.VENDOR;
        }
    }
}

