/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.metrics.MetricMeasurement;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.spi.MetricsService;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;

public class MicrometerMetricsService
implements MetricsService {
    private final MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final Map<Long, MetricMeasurement<Timer.Sample>> metricsMemory = new ConcurrentHashMap<Long, MetricMeasurement<Timer.Sample>>();
    private final Map<String, AtomicLong> subscriptions = new ConcurrentHashMap<String, AtomicLong>();
    private static final String METRIC_NAME = "mp_graphql";
    private static final String METRIC_SUBSCRIPTIONS = "mp_graphql_subscription";
    private Logger LOG = Logger.getLogger(MicrometerMetricsService.class);

    public MicrometerMetricsService() {
        this.meterRegistry.getMeters();
    }

    private Tags getTags(MetricMeasurement<Timer.Sample> metricMeasurement) {
        return Tags.of((String)"name", (String)metricMeasurement.getName()).and("type", metricMeasurement.getOperationType()).and("source", String.valueOf(metricMeasurement.isSource()));
    }

    public void start(Long measurementId, Context context) {
        this.metricsMemory.put(measurementId, new MetricMeasurement<Timer.Sample>(context.getFieldName(), context.hasSource(), context.getOperationType(), Timer.start()));
        this.LOG.tracef("(" + measurementId + ") Started recording metrics for: %s", (Object)context.getFieldName());
    }

    public void end(Long measurementId) {
        MetricMeasurement<Timer.Sample> metricMeasurement = this.metricsMemory.remove(measurementId);
        Timer timer = this.meterRegistry.timer(METRIC_NAME, (Iterable)this.getTags(metricMeasurement));
        metricMeasurement.getMetric().stop(timer);
        this.LOG.tracef("(" + measurementId + ") Finished recording metrics for: %s", (Object)metricMeasurement.getName());
    }

    public void subscriptionStart(Context context) {
        if (!OperationType.SUBSCRIPTION.name().equals(context.getOperationType())) {
            return;
        }
        this.subscriptions.computeIfAbsent(context.getFieldName(), k -> new AtomicLong(0L));
        this.subscriptions.get(context.getFieldName()).incrementAndGet();
        this.meterRegistry.gauge(METRIC_SUBSCRIPTIONS, (Iterable)Tags.of((String)"name", (String)context.getFieldName()), (Object)this.subscriptions.get(context.getFieldName()), AtomicLong::get);
    }

    public void subscriptionEnd(Context context) {
        if (!OperationType.SUBSCRIPTION.name().equals(context.getOperationType())) {
            return;
        }
        Optional.ofNullable(this.subscriptions.get(context.getFieldName())).ifPresent(AtomicLong::decrementAndGet);
    }
}

