/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core;

import io.smallrye.graphql.client.core.Directive;
import io.smallrye.graphql.client.core.FieldOrFragment;
import io.smallrye.graphql.client.core.Fragment;
import io.smallrye.graphql.client.core.utils.ServiceUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface FragmentReference
extends FieldOrFragment {
    public static FragmentReference fragmentRef(String name) {
        FragmentReference ref = ServiceUtils.getNewInstanceOf(FragmentReference.class);
        ref.setName(name);
        ref.setDirectives(Collections.emptyList());
        return ref;
    }

    public static FragmentReference fragmentRef(Fragment fragment) {
        FragmentReference ref = ServiceUtils.getNewInstanceOf(FragmentReference.class);
        ref.setName(fragment.getName());
        ref.setDirectives(Collections.emptyList());
        return ref;
    }

    public static FragmentReference fragmentRefWithDirective(String name, Directive ... directives) {
        FragmentReference ref = ServiceUtils.getNewInstanceOf(FragmentReference.class);
        ref.setName(name);
        ref.setDirectives(Arrays.asList(directives));
        return ref;
    }

    public static FragmentReference fragmentRefWithDirective(Fragment fragment, Directive ... directives) {
        FragmentReference ref = ServiceUtils.getNewInstanceOf(FragmentReference.class);
        ref.setName(fragment.getName());
        ref.setDirectives(Arrays.asList(directives));
        return ref;
    }

    public String getName();

    public void setName(String var1);

    public List<Directive> getDirectives();

    public void setDirectives(List<Directive> var1);
}

