/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.core;

import io.smallrye.graphql.client.core.Buildable;
import io.smallrye.graphql.client.core.Directive;
import io.smallrye.graphql.client.core.ScalarType;
import io.smallrye.graphql.client.core.VariableType;
import io.smallrye.graphql.client.core.utils.ServiceUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface Variable
extends Buildable {
    public static List<Variable> vars(Variable ... vars) {
        return Arrays.asList(vars);
    }

    public static Variable var(String name, ScalarType scalarType) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(scalarType));
        var.setDefaultValue(Optional.empty());
        var.setDirectives(Collections.emptyList());
        return var;
    }

    public static Variable varWithDirectives(String name, ScalarType scalarType, List<Directive> directives) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(scalarType));
        var.setDefaultValue(Optional.empty());
        var.setDirectives(directives);
        return var;
    }

    public static Variable var(String name, ScalarType scalarType, Object defaultValue) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(scalarType));
        var.setDefaultValue(Optional.of(defaultValue));
        var.setDirectives(Collections.emptyList());
        return var;
    }

    public static Variable varWithDirectives(String name, ScalarType scalarType, Object defaultValue, List<Directive> directives) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(scalarType));
        var.setDefaultValue(Optional.of(defaultValue));
        var.setDirectives(directives);
        return var;
    }

    public static Variable var(String name, String objectTypeName) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(objectTypeName));
        var.setDefaultValue(Optional.empty());
        var.setDirectives(Collections.emptyList());
        return var;
    }

    public static Variable varWithDirectives(String name, String objectTypeName, List<Directive> directives) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(objectTypeName));
        var.setDefaultValue(Optional.empty());
        var.setDirectives(directives);
        return var;
    }

    public static Variable var(String name, String objectTypeName, Object defaultValue) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(objectTypeName));
        var.setDefaultValue(Optional.of(defaultValue));
        var.setDirectives(Collections.emptyList());
        return var;
    }

    public static Variable varWithDirectives(String name, String objectTypeName, Object defaultValue, List<Directive> directives) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(VariableType.varType(objectTypeName));
        var.setDefaultValue(Optional.of(defaultValue));
        var.setDirectives(directives);
        return var;
    }

    public static Variable var(String name, VariableType varType) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(varType);
        var.setDefaultValue(Optional.empty());
        var.setDirectives(Collections.emptyList());
        return var;
    }

    public static Variable varWithDirectives(String name, VariableType varType, List<Directive> directives) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(varType);
        var.setDefaultValue(Optional.empty());
        var.setDirectives(directives);
        return var;
    }

    public static Variable var(String name, VariableType varType, Object defaultValue) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(varType);
        var.setDefaultValue(Optional.of(defaultValue));
        var.setDirectives(Collections.emptyList());
        return var;
    }

    public static Variable varWithDirectives(String name, VariableType varType, Object defaultValue, List<Directive> directives) {
        Variable var = ServiceUtils.getNewInstanceOf(Variable.class);
        var.setName(name);
        var.setType(varType);
        var.setDefaultValue(Optional.of(defaultValue));
        var.setDirectives(directives);
        return var;
    }

    public String getName();

    public void setName(String var1);

    public VariableType getType();

    public void setType(VariableType var1);

    public Optional<Object> getDefaultValue();

    public void setDefaultValue(Optional<Object> var1);

    public List<Directive> getDirectives();

    public void setDirectives(List<Directive> var1);
}

