/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.typesafe;

import io.smallrye.graphql.api.Namespace;
import io.smallrye.graphql.client.impl.ErrorMessageProvider;
import io.smallrye.graphql.client.impl.GraphQLClientConfiguration;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.model.ClientModel;
import io.smallrye.graphql.client.model.ClientModels;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.TypesafeGraphQLClientBuilder;
import io.smallrye.graphql.client.vertx.VertxClientOptionsHelper;
import io.smallrye.graphql.client.vertx.VertxManager;
import io.smallrye.graphql.client.vertx.typesafe.VertxTypesafeGraphQLClientProxy;
import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.graphql.Name;
import org.jboss.logging.Logger;

public class VertxTypesafeGraphQLClientBuilder
implements TypesafeGraphQLClientBuilder {
    private static final Logger log = Logger.getLogger(VertxTypesafeGraphQLClientBuilder.class);
    private String configKey = null;
    private URI endpoint;
    private String websocketUrl;
    private Boolean executeSingleOperationsOverWebsocket;
    private Map<String, String> headers;
    private Map<String, Uni<String>> dynamicHeaders;
    private Map<String, Object> initPayload;
    private List<WebsocketSubprotocol> subprotocols = new ArrayList<WebsocketSubprotocol>();
    private Vertx vertx;
    private HttpClientOptions options;
    private WebClient webClient;
    private HttpClient httpClient;
    private Integer websocketInitializationTimeout;
    private Boolean allowUnexpectedResponseFields;
    private ClientModels clientModels;

    public VertxTypesafeGraphQLClientBuilder configKey(String configKey) {
        this.configKey = configKey;
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder vertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder client(WebClient webClient) {
        this.webClient = webClient;
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder options(HttpClientOptions options) {
        this.options = options;
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder endpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TypesafeGraphQLClientBuilder websocketUrl(String url) {
        this.websocketUrl = url;
        return this;
    }

    public TypesafeGraphQLClientBuilder executeSingleOperationsOverWebsocket(boolean value) {
        this.executeSingleOperationsOverWebsocket = value;
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder dynamicHeader(String name, Uni<String> value) {
        if (this.dynamicHeaders == null) {
            this.dynamicHeaders = new LinkedHashMap<String, Uni<String>>();
        }
        this.dynamicHeaders.put(name, value);
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder initPayload(Map<String, Object> initPayload) {
        if (this.initPayload == null) {
            this.initPayload = new LinkedHashMap<String, Object>();
        }
        this.initPayload.putAll(initPayload);
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder subprotocols(WebsocketSubprotocol ... subprotocols) {
        this.subprotocols.addAll(Arrays.asList(subprotocols));
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder clientModels(ClientModels clientModels) {
        this.clientModels = clientModels;
        return this;
    }

    public TypesafeGraphQLClientBuilder allowUnexpectedResponseFields(boolean value) {
        this.allowUnexpectedResponseFields = value;
        return this;
    }

    public VertxTypesafeGraphQLClientBuilder websocketInitializationTimeout(Integer timeoutInMilliseconds) {
        this.websocketInitializationTimeout = timeoutInMilliseconds;
        return this;
    }

    public <T> T build(Class<T> apiClass) {
        Name nameAnnotation = apiClass.getAnnotation(Name.class);
        Namespace namespaceAnnotation = apiClass.getAnnotation(Namespace.class);
        if (nameAnnotation != null && namespaceAnnotation != null) {
            throw new RuntimeException("You can only use one of the annotations - @Name or @Namespace over the GraphQLClientApi interface. Please, fix the following interface: " + apiClass.getName());
        }
        if (this.options == null) {
            this.options = new WebClientOptions();
        }
        if (this.configKey == null) {
            this.configKey = this.configKey(apiClass);
        }
        this.applyConfigFor(apiClass);
        if (this.endpoint == null) {
            throw ErrorMessageProvider.get().urlMissingErrorForNamedClient(this.configKey);
        }
        this.initClients();
        if (this.subprotocols == null || this.subprotocols.isEmpty()) {
            this.subprotocols = new ArrayList<WebsocketSubprotocol>(EnumSet.of(WebsocketSubprotocol.GRAPHQL_TRANSPORT_WS));
        }
        if (this.websocketUrl == null) {
            this.websocketUrl = this.endpoint.toString().replaceFirst("http", "ws");
        }
        if (this.executeSingleOperationsOverWebsocket == null) {
            this.executeSingleOperationsOverWebsocket = false;
        }
        if (this.allowUnexpectedResponseFields == null) {
            this.allowUnexpectedResponseFields = false;
        }
        if (this.dynamicHeaders == null) {
            this.dynamicHeaders = new HashMap<String, Uni<String>>();
        }
        ClientModel clientModel = null;
        if (this.clientModels != null) {
            clientModel = this.clientModels.getClientModelByConfigKey(this.configKey);
        }
        VertxTypesafeGraphQLClientProxy graphQLClient = new VertxTypesafeGraphQLClientProxy(apiClass, clientModel, this.headers, this.dynamicHeaders, this.initPayload, this.endpoint, this.websocketUrl, this.executeSingleOperationsOverWebsocket, this.httpClient, this.webClient, this.subprotocols, this.websocketInitializationTimeout, this.allowUnexpectedResponseFields);
        return apiClass.cast(Proxy.newProxyInstance(this.getClassLoader(apiClass), new Class[]{apiClass}, (proxy, method, args) -> this.invoke(graphQLClient, method, args)));
    }

    private void applyConfigFor(Class<?> apiClass) {
        GraphQLClientsConfiguration configs = GraphQLClientsConfiguration.getInstance();
        configs.initTypesafeClientApi(apiClass);
        GraphQLClientConfiguration persistentConfig = configs.getClient(this.configKey);
        if (persistentConfig != null) {
            this.applyConfig(persistentConfig);
        }
    }

    private void initClients() {
        if (this.webClient == null) {
            if (this.httpClient == null) {
                this.httpClient = this.options != null ? this.vertx().createHttpClient(this.options) : this.vertx().createHttpClient();
            }
            this.webClient = WebClient.wrap((HttpClient)this.httpClient);
        } else if (this.httpClient == null) {
            this.httpClient = this.options != null ? this.vertx().createHttpClient(this.options) : this.vertx().createHttpClient();
        }
    }

    private Vertx vertx() {
        return this.vertx != null ? this.vertx : VertxManager.get();
    }

    private Object invoke(VertxTypesafeGraphQLClientProxy graphQlClient, Method method, Object ... args) {
        MethodInvocation methodInvocation = MethodInvocation.of((Method)method, (Object[])args);
        if (methodInvocation.isDeclaredInCloseable()) {
            graphQlClient.close();
            return null;
        }
        return graphQlClient.invoke(methodInvocation);
    }

    private ClassLoader getClassLoader(Class<?> apiClass) {
        if (System.getSecurityManager() == null) {
            return apiClass.getClassLoader();
        }
        return AccessController.doPrivileged(apiClass::getClassLoader);
    }

    private void applyConfig(GraphQLClientConfiguration configuration) {
        if (this.endpoint == null && configuration.getUrl() != null) {
            this.endpoint = URI.create(configuration.getUrl());
        }
        if (this.websocketUrl == null && configuration.getWebsocketUrl() != null) {
            this.websocketUrl = configuration.getWebsocketUrl();
        }
        if (this.headers == null && configuration.getHeaders() != null) {
            this.headers = configuration.getHeaders();
        }
        if (this.dynamicHeaders == null && configuration.getDynamicHeaders() != null) {
            this.dynamicHeaders = configuration.getDynamicHeaders();
        }
        if (this.initPayload == null && configuration.getInitPayload() != null) {
            this.initPayload = configuration.getInitPayload();
        }
        if (this.websocketInitializationTimeout == null && configuration.getWebsocketInitializationTimeout() != null) {
            this.websocketInitializationTimeout = configuration.getWebsocketInitializationTimeout();
        }
        if (this.executeSingleOperationsOverWebsocket == null && configuration.getExecuteSingleOperationsOverWebsocket() != null) {
            this.executeSingleOperationsOverWebsocket = configuration.getExecuteSingleOperationsOverWebsocket();
        }
        if (this.allowUnexpectedResponseFields == null && configuration.getAllowUnexpectedResponseFields() != null) {
            this.allowUnexpectedResponseFields = configuration.getAllowUnexpectedResponseFields();
        }
        if (configuration.getWebsocketSubprotocols() != null) {
            configuration.getWebsocketSubprotocols().forEach(protocol -> {
                try {
                    WebsocketSubprotocol e = WebsocketSubprotocol.fromString((String)protocol);
                    this.subprotocols.add(e);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
            });
        }
        VertxClientOptionsHelper.applyConfigToVertxOptions(this.options, configuration);
    }

    private String configKey(Class<?> apiClass) {
        GraphQLClientApi annotation = apiClass.getAnnotation(GraphQLClientApi.class);
        if (annotation == null) {
            return apiClass.getName();
        }
        String keyFromAnnotation = annotation.configKey();
        return keyFromAnnotation.isEmpty() ? apiClass.getName() : keyFromAnnotation;
    }
}

