/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.model.helper;

import io.smallrye.graphql.client.model.Annotations;
import io.smallrye.graphql.client.model.ScanningContext;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;

public class DirectiveHelper {
    public static Stream<AnnotationInstance> resolveDirectives(Stream<AnnotationInstance> annotationInstances, String directiveLocation, AnnotationTarget.Kind targetKind) {
        return DirectiveHelper.resolveDirectives(annotationInstances.filter(annotation -> annotation.target().kind() == targetKind), directiveLocation);
    }

    public static Stream<AnnotationInstance> resolveDirectives(Stream<AnnotationInstance> annotationInstances, String directiveLocation) {
        return annotationInstances.flatMap(annotationInstance -> {
            ClassInfo scannedAnnotation = ScanningContext.getIndex().getClassByName(annotationInstance.name());
            if (scannedAnnotation != null) {
                if (scannedAnnotation.hasAnnotation(Annotations.DIRECTIVE)) {
                    return Stream.of(annotationInstance);
                }
                Optional<AnnotationInstance> repeatableAnnotation = ScanningContext.getIndex().getAnnotations(Annotations.REPEATABLE).stream().filter(annotation -> annotation.target().hasAnnotation(Annotations.DIRECTIVE) && annotation.value().asClass().name().equals((Object)annotationInstance.name())).findFirst();
                if (repeatableAnnotation.isPresent()) {
                    return Stream.of(annotationInstance.value().asNestedArray());
                }
            }
            return Stream.empty();
        }).filter(annotation -> DirectiveHelper.directiveFilter(annotation, directiveLocation));
    }

    private static boolean directiveFilter(AnnotationInstance annotation, String directiveLocation) {
        return Arrays.stream(ScanningContext.getIndex().getClassByName(annotation.name()).annotation(Annotations.DIRECTIVE).value("on").asEnumArray()).anyMatch(directiveLocation::equals);
    }
}

