/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.GraphQLError;
import io.smallrye.graphql.client.Response;
import io.smallrye.graphql.client.impl.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.impl.typesafe.json.JsonReader;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseImpl
implements Response {
    public static final String STATUS_CODE = "<status-code>";
    public static final String STATUS_MESSAGE = "<status-message>";
    private final JsonObject data;
    private final List<GraphQLError> errors;
    private final JsonObject extensions;
    private final Map<String, List<String>> metadata;

    public ResponseImpl(JsonObject data, List<GraphQLError> errors, Map<String, List<String>> headers) {
        this(data, errors, null, headers);
    }

    public ResponseImpl(JsonObject data, List<GraphQLError> errors, JsonObject extensions, Map<String, List<String>> headers) {
        this.data = data;
        this.errors = errors;
        this.extensions = extensions;
        this.metadata = Collections.unmodifiableMap(headers != null ? headers : Collections.emptyMap());
    }

    public ResponseImpl(JsonObject data, List<GraphQLError> errors, Map<String, List<String>> headers, Integer statusCode, String statusMessage) {
        this(data, errors, null, headers, statusCode, statusMessage);
    }

    public ResponseImpl(JsonObject data, List<GraphQLError> errors, JsonObject extensions, Map<String, List<String>> headers, Integer statusCode, String statusMessage) {
        this.data = data;
        this.errors = errors;
        this.extensions = extensions;
        HashMap<String, List<String>> meta = new HashMap<String, List<String>>();
        if (headers != null) {
            meta.putAll(headers);
        }
        if (statusCode != null) {
            meta.put(STATUS_CODE, List.of(String.valueOf(statusCode)));
        }
        if (statusMessage != null) {
            meta.put(STATUS_MESSAGE, List.of(statusMessage));
        }
        this.metadata = Collections.unmodifiableMap(meta);
    }

    public <T> T getObject(Class<T> dataType, String rootField) {
        if (this.data == null || this.data.equals(JsonValue.NULL) || this.data.keySet().isEmpty()) {
            throw SmallRyeGraphQLClientMessages.msg.noDataInResponse();
        }
        JsonValue value = (JsonValue)this.data.get((Object)rootField);
        if (value == null) {
            throw SmallRyeGraphQLClientMessages.msg.fieldNotFoundInResponse(rootField, this.data.keySet());
        }
        if (value.getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            return null;
        }
        if (value.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
            return (T)JsonReader.readJson(rootField, TypeInfo.of(dataType), (JsonValue)value.asJsonObject(), null);
        }
        if (value.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
            throw SmallRyeGraphQLClientMessages.msg.responseContainsArray(rootField);
        }
        Object scalarValue = this.getScalarValue(value);
        if (scalarValue != null) {
            return (T)scalarValue;
        }
        throw SmallRyeGraphQLClientMessages.msg.unexpectedValueInResponse(rootField, value.getValueType().toString());
    }

    public <T> List<T> getList(Class<T> dataType, String rootField) {
        if (this.data == null || this.data.equals(JsonValue.NULL) || this.data.keySet().isEmpty()) {
            throw SmallRyeGraphQLClientMessages.msg.noDataInResponse();
        }
        JsonValue item = (JsonValue)this.data.get((Object)rootField);
        if (item == null) {
            throw SmallRyeGraphQLClientMessages.msg.fieldNotFoundInResponse(rootField, this.data.keySet());
        }
        if (item.getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            return null;
        }
        if (item instanceof JsonObject) {
            throw SmallRyeGraphQLClientMessages.msg.responseContainsSingleObject(rootField);
        }
        if (item instanceof JsonArray) {
            ArrayList result = new ArrayList();
            JsonArray jsonArray = (JsonArray)item;
            TypeInfo type = TypeInfo.of(dataType);
            jsonArray.forEach(o -> {
                if (o.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                    result.add(JsonReader.readJson(rootField, type, o, null));
                } else {
                    result.add(this.getScalarValue((JsonValue)o));
                }
            });
            return result;
        }
        throw SmallRyeGraphQLClientMessages.msg.unexpectedValueInResponse(rootField, item.getValueType().toString());
    }

    private Object getScalarValue(JsonValue value) {
        switch (value.getValueType()) {
            case NUMBER: {
                return ((JsonNumber)value).longValue();
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return null;
    }

    public JsonObject getData() {
        return this.data;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public JsonObject getExtensions() {
        return this.extensions;
    }

    public void throwExceptionIfErrors() {
        if (!this.errors.isEmpty()) {
            throw new GraphQLClientException("Errors from service", this.errors);
        }
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasError() {
        return this.errors != null;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public String toString() {
        return "ResponseImpl{data=" + this.data + ", errors=" + this.errors + ", extensions=" + this.extensions + "}";
    }

    public Map<String, List<String>> getHeaders() {
        return this.metadata;
    }

    public Map<String, List<String>> getTransportMeta() {
        return this.metadata;
    }

    public Integer getStatusCode() {
        if (this.metadata.containsKey(STATUS_CODE)) {
            return Integer.valueOf(this.metadata.get(STATUS_CODE).get(0));
        }
        return null;
    }

    public String getStatusMessage() {
        if (this.metadata.containsKey(STATUS_MESSAGE)) {
            return this.metadata.get(STATUS_MESSAGE).get(0);
        }
        return null;
    }
}

