/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.creator.ArgumentCreator;
import io.smallrye.graphql.schema.creator.ModelCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DeprecatedDirectivesHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.RolesAllowedDirectivesHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Execute;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.OperationType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.Type;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassifier;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmTypeProjection;
import kotlinx.metadata.KmValueParameter;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class OperationCreator
extends ModelCreator {
    private final ArgumentCreator argumentCreator;
    private final RolesAllowedDirectivesHelper rolesAllowedHelper;
    private final DeprecatedDirectivesHelper deprecatedHelper;
    private final Logger logger = Logger.getLogger((String)OperationCreator.class.getName());

    public OperationCreator(ReferenceCreator referenceCreator, ArgumentCreator argumentCreator) {
        super(referenceCreator);
        this.argumentCreator = argumentCreator;
        this.rolesAllowedHelper = new RolesAllowedDirectivesHelper();
        this.deprecatedHelper = new DeprecatedDirectivesHelper();
    }

    public Operation createOperation(MethodInfo methodInfo, OperationType operationType, Type type) {
        if (!Modifier.isPublic(methodInfo.flags())) {
            throw new IllegalArgumentException("Method " + methodInfo.declaringClass().name().toString() + "#" + methodInfo.name() + " is used as an operation, but is not public");
        }
        Annotations annotationsForMethod = Annotations.getAnnotationsForMethod(methodInfo);
        Annotations annotationsForClass = Annotations.getAnnotationsForClass(methodInfo.declaringClass());
        org.jboss.jandex.Type fieldType = OperationCreator.getReturnType(methodInfo);
        String name = OperationCreator.getOperationName(methodInfo, operationType, annotationsForMethod);
        OperationCreator.validateFieldType(methodInfo, operationType);
        Execute execute = this.getExecution(annotationsForMethod, annotationsForClass);
        Reference reference = this.referenceCreator.createReferenceForOperationField(fieldType, annotationsForMethod);
        Operation operation = new Operation(methodInfo.declaringClass().name().toString(), methodInfo.name(), MethodHelper.getPropertyName(Direction.OUT, methodInfo.name()), name, reference, operationType, execute);
        if (type != null) {
            operation.setSourceFieldOn(new Reference.Builder().reference((Reference)type).build());
        }
        List parameters = methodInfo.parameterTypes();
        for (short i = 0; i < parameters.size(); i = (short)(i + 1)) {
            Optional<Argument> maybeArgument = this.argumentCreator.createArgument(operation, methodInfo, i);
            maybeArgument.ifPresent(arg_0 -> ((Operation)operation).addArgument(arg_0));
        }
        this.addDirectivesForRolesAllowed(annotationsForMethod, annotationsForClass, operation, reference);
        this.addDirectiveForDeprecated(annotationsForMethod, operation);
        this.populateField(Direction.OUT, (Field)operation, fieldType, annotationsForMethod);
        if (operation.hasWrapper()) {
            this.checkWrappedTypeKotlinNullability(methodInfo, annotationsForClass, operation);
        }
        return operation;
    }

    private void checkWrappedTypeKotlinNullability(MethodInfo methodInfo, Annotations annotationsForClass, Operation operation) {
        KmType returnType;
        KmTypeProjection arg;
        int flags;
        boolean nullable;
        KotlinClassMetadata.Class kotlinClass;
        Optional<KmFunction> function;
        Optional<AnnotationInstance> kotlinMetadataAnnotation = annotationsForClass.getOneOfTheseAnnotations(Annotations.KOTLIN_METADATA);
        if (kotlinMetadataAnnotation.isPresent() && (function = (kotlinClass = this.toKotlinClassMetadata(kotlinMetadataAnnotation.get())).getKmClass().getFunctions().stream().filter(f -> f.getName().equals(methodInfo.name())).filter(f -> this.compareParameterLists(f.getValueParameters(), methodInfo.parameterTypes())).findAny()).isPresent() && (nullable = Flag.Type.IS_NULLABLE.invoke(flags = (arg = (KmTypeProjection)(returnType = function.get().getReturnType()).getArguments().get(0)).getType().getFlags()))) {
            operation.setNotNull(false);
        }
    }

    private boolean compareParameterLists(List<KmValueParameter> kotlinParameters, List<org.jboss.jandex.Type> jandexParameters) {
        if (kotlinParameters.size() != jandexParameters.size()) {
            return false;
        }
        for (int i = 0; i < kotlinParameters.size(); ++i) {
            if (((KmClassifier.Class)kotlinParameters.get((int)i).getType().classifier).getName().replace("/", ".").equals(jandexParameters.get(i).name().toString())) continue;
            return false;
        }
        return true;
    }

    private KotlinClassMetadata.Class toKotlinClassMetadata(AnnotationInstance metadata) {
        KotlinClassHeader classHeader = new KotlinClassHeader(Integer.valueOf(metadata.value("k").asInt()), metadata.value("mv").asIntArray(), metadata.value("d1").asStringArray(), metadata.value("d2").asStringArray(), metadata.value("xs") != null ? metadata.value("xs").asString() : null, metadata.value("pn") != null ? metadata.value("pn").asString() : null, Integer.valueOf(metadata.value("xi").asInt()));
        return (KotlinClassMetadata.Class)KotlinClassMetadata.read((Metadata)classHeader);
    }

    private static void validateFieldType(MethodInfo methodInfo, OperationType operationType) {
        org.jboss.jandex.Type returnType = methodInfo.returnType();
        if (!operationType.equals((Object)OperationType.MUTATION) && returnType.kind().equals((Object)Type.Kind.VOID)) {
            throw new SchemaBuilderException("Can not have a void return for [" + operationType.name() + "] on method [" + methodInfo.name() + "]");
        }
    }

    private static String getOperationName(MethodInfo methodInfo, OperationType operationType, Annotations annotations) {
        DotName operationAnnotation = OperationCreator.getOperationAnnotation(operationType);
        return annotations.getOneOfTheseMethodAnnotationsValue(operationAnnotation, Annotations.NAME, Annotations.JAKARTA_JSONB_PROPERTY, Annotations.JAVAX_JSONB_PROPERTY, Annotations.JACKSON_PROPERTY).orElse(OperationCreator.getDefaultExecutionTypeName(methodInfo, operationType));
    }

    private static DotName getOperationAnnotation(OperationType operationType) {
        switch (operationType) {
            case QUERY: {
                return Annotations.QUERY;
            }
            case MUTATION: {
                return Annotations.MUTATION;
            }
            case SUBSCRIPTION: {
                return Annotations.SUBCRIPTION;
            }
        }
        return null;
    }

    private static String getDefaultExecutionTypeName(MethodInfo methodInfo, OperationType operationType) {
        String methodName = methodInfo.name();
        if (operationType.equals((Object)OperationType.QUERY) || operationType.equals((Object)OperationType.SUBSCRIPTION)) {
            methodName = MethodHelper.getPropertyName(Direction.OUT, methodName);
        } else if (operationType.equals((Object)OperationType.MUTATION)) {
            methodName = MethodHelper.getPropertyName(Direction.IN, methodName);
        }
        return methodName;
    }

    private Execute getExecution(Annotations annotationsForMethod, Annotations annotationsForClass) {
        if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.BLOCKING)) {
            return Execute.BLOCKING;
        }
        if (annotationsForMethod.containsOneOfTheseAnnotations(Annotations.NON_BLOCKING)) {
            return Execute.NON_BLOCKING;
        }
        if (annotationsForClass.containsOneOfTheseAnnotations(Annotations.BLOCKING)) {
            return Execute.BLOCKING;
        }
        if (annotationsForClass.containsOneOfTheseAnnotations(Annotations.NON_BLOCKING)) {
            return Execute.NON_BLOCKING;
        }
        return Execute.DEFAULT;
    }

    private void addDirectivesForRolesAllowed(Annotations annotationsForOperation, Annotations classAnnotations, Operation operation, Reference parentObjectReference) {
        this.rolesAllowedHelper.transformRolesAllowedToDirectives(annotationsForOperation, classAnnotations).ifPresent(rolesAllowedDirective -> {
            this.logger.debug((Object)("Adding rolesAllowed directive " + rolesAllowedDirective + " to method '" + operation.getName() + "'"));
            operation.addDirectiveInstance(rolesAllowedDirective);
        });
    }

    private void addDirectiveForDeprecated(Annotations annotationsForOperation, Operation operation) {
        if (this.deprecatedHelper != null && this.directives != null) {
            this.deprecatedHelper.transformDeprecatedToDirective(annotationsForOperation, this.directives.getDirectiveTypes().get(DotName.createSimple((String)"io.smallrye.graphql.api.Deprecated"))).ifPresent(deprecatedDirective -> {
                this.logger.debug((Object)("Adding deprecated directive " + deprecatedDirective + " to method '" + operation.getName() + "'"));
                operation.addDirectiveInstance(deprecatedDirective);
            });
        }
    }

    @Override
    public String getDirectiveLocation() {
        return "FIELD_DEFINITION";
    }
}

