/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import io.smallrye.graphql.JsonProviderHolder;
import io.smallrye.graphql.api.ErrorExtensionProvider;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.schema.model.ErrorInfo;
import jakarta.json.JsonValue;
import java.util.Locale;

public class ErrorCodeExtensionProvider
implements ErrorExtensionProvider {
    public String getKey() {
        return "code";
    }

    public JsonValue mapValueFrom(Throwable exception) {
        return JsonProviderHolder.JSON_PROVIDER.createValue(this.errorCode(exception));
    }

    private String errorCode(Throwable exception) {
        ErrorInfo errorInfo = ErrorInfoMap.getErrorInfo(exception.getClass().getName());
        if (errorInfo == null) {
            return ErrorCodeExtensionProvider.camelToKebab(exception.getClass().getSimpleName().replaceAll("Exception$", ""));
        }
        return errorInfo.getErrorCode();
    }

    private static String camelToKebab(String input) {
        return String.join((CharSequence)"-", input.split("(?=\\p{javaUpperCase})")).toLowerCase(Locale.ROOT);
    }
}

