/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.validation;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BeanValidationError
implements GraphQLError {
    private final Set<ConstraintViolation<?>> violations;
    private final ResultPath resultPath;
    private final List<SourceLocation> sourceLocations;

    public BeanValidationError(Set<ConstraintViolation<?>> violations, ResultPath resultPath, List<SourceLocation> sourceLocations) {
        this.violations = violations;
        this.resultPath = resultPath;
        this.sourceLocations = sourceLocations;
    }

    public ErrorClassification getErrorType() {
        return ErrorType.ValidationError;
    }

    public String getMessage() {
        String joinedMessage = this.violations.stream().map(violation -> violation.getPropertyPath() + " " + violation.getMessage()).collect(Collectors.joining(", "));
        return "validation failed: " + joinedMessage;
    }

    public List<SourceLocation> getLocations() {
        return this.sourceLocations;
    }

    public List<Object> getPath() {
        return this.resultPath.toList();
    }

    public Map<String, Object> getExtensions() {
        return Map.of("violations", this.violations.stream().map(this::getViolationAttributes).collect(Collectors.toList()));
    }

    private Map<String, Object> getViolationAttributes(ConstraintViolation<?> violation) {
        return Map.of("message", violation.getMessage(), "propertyPath", BeanValidationError.toStream(violation.getPropertyPath()).flatMap(this::items).collect(Collectors.toList()), "invalidValue", violation.getInvalidValue(), "constraint", this.getConstraintAttributes(violation));
    }

    private Stream<String> items(Path.Node node) {
        if (node.getIndex() == null) {
            return Stream.of(node.getName());
        }
        return Stream.of(node.getIndex().toString(), node.getName());
    }

    private Map<String, Object> getConstraintAttributes(ConstraintViolation<?> violation) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(violation.getConstraintDescriptor().getAttributes());
        attributes.computeIfPresent("groups", BeanValidationError::classNames);
        attributes.computeIfPresent("payload", BeanValidationError::classNames);
        return attributes;
    }

    private static Object classNames(String key, Object oldValue) {
        return Stream.of((Class[])oldValue).map(Class::getName).collect(Collectors.toList());
    }

    static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

