/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import io.smallrye.graphql.spi.config.Config;
import java.util.concurrent.CompletableFuture;

public class ExceptionHandler
implements DataFetcherExceptionHandler {
    private final Config config = Config.get();

    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable throwable = handlerParameters.getException();
        throwable = this.unwrapThrowable(throwable);
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ResultPath path = handlerParameters.getPath();
        ExceptionWhileDataFetching error = this.getExceptionWhileDataFetching(throwable, sourceLocation, path);
        if (this.config.isPrintDataFetcherException()) {
            SmallRyeGraphQLServerLogging.log.dataFetchingError(throwable);
        }
        return CompletableFuture.completedFuture(DataFetcherExceptionHandlerResult.newResult().error((GraphQLError)error).build());
    }

    private ExceptionWhileDataFetching getExceptionWhileDataFetching(Throwable throwable, SourceLocation sourceLocation, ResultPath path) {
        if (throwable instanceof RuntimeException) {
            if (this.config.shouldShow(throwable)) {
                return new GraphQLExceptionWhileDataFetching(path, throwable, sourceLocation);
            }
            return new GraphQLExceptionWhileDataFetching(this.config.getDefaultErrorMessage(), path, throwable, sourceLocation);
        }
        if (this.config.shouldHide(throwable)) {
            return new GraphQLExceptionWhileDataFetching(this.config.getDefaultErrorMessage(), path, throwable, sourceLocation);
        }
        return new GraphQLExceptionWhileDataFetching(path, throwable, sourceLocation);
    }

    private Throwable unwrapThrowable(Throwable t) {
        if (this.config.shouldUnwrapThrowable(t)) {
            t = t.getCause();
            return this.unwrapThrowable(t);
        }
        return t;
    }
}

