/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtSignature;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.ImplMessages;
import io.smallrye.jwt.build.impl.JwtBuildUtils;
import io.smallrye.jwt.build.impl.JwtEncryptionImpl;
import io.smallrye.jwt.util.KeyUtils;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;

class JwtSignatureImpl
implements JwtSignature {
    JwtClaims claims = new JwtClaims();
    Map<String, Object> headers = new HashMap<String, Object>();
    Long tokenLifespan;

    JwtSignatureImpl() {
    }

    JwtSignatureImpl(JwtClaims claims) {
        this.claims = claims;
    }

    @Override
    public String sign(PrivateKey signingKey) throws JwtSignatureException {
        return this.signInternal(signingKey);
    }

    @Override
    public String sign(SecretKey signingKey) throws JwtSignatureException {
        return this.signInternal(signingKey);
    }

    @Override
    public String sign(String keyLocation) throws JwtSignatureException {
        try {
            return this.signInternal(this.getSigningKeyFromKeyLocation(keyLocation));
        }
        catch (JwtSignatureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signatureException(ex);
        }
    }

    @Override
    public String sign() throws JwtSignatureException {
        try {
            Key key = null;
            if (!"none".equals(this.headers.get("alg"))) {
                key = this.getSigningKeyFromKeyLocation(JwtSignatureImpl.getKeyLocationFromConfig());
            }
            return this.signInternal(key);
        }
        catch (JwtSignatureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signatureException(ex);
        }
    }

    @Override
    public String signWithSecret(String secret) throws JwtSignatureException {
        return this.sign(KeyUtils.createSecretKeyFromSecret((String)secret));
    }

    @Override
    public JwtEncryptionBuilder innerSign(PrivateKey signingKey) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(signingKey), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign(SecretKey signingKey) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(signingKey), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign(String keyLocation) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(keyLocation), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign() throws JwtSignatureException {
        if (!JwtSignatureImpl.signingKeyConfigured()) {
            if (this.headers.containsKey("alg") && !"none".equals(this.headers.get("alg"))) {
                throw ImplMessages.msg.signKeyPropertyRequired(this.headers.get("alg").toString());
            }
            if (this.headers.containsKey("kid")) {
                throw ImplMessages.msg.signAlgorithmRequired();
            }
            this.headers.put("alg", "none");
        }
        return new JwtEncryptionImpl(this.sign(), true);
    }

    @Override
    public JwtEncryptionBuilder innerSignWithSecret(String secret) throws JwtSignatureException {
        return this.innerSign(KeyUtils.createSecretKeyFromSecret((String)secret));
    }

    private static boolean signingKeyConfigured() {
        try {
            ConfigProvider.getConfig().getValue("smallrye.jwt.sign.key-location", String.class);
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    private String signInternal(Key signingKey) {
        String algorithm;
        JwtBuildUtils.setDefaultJwtClaims(this.claims, this.tokenLifespan);
        JsonWebSignature jws = new JsonWebSignature();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            jws.setHeader(entry.getKey(), entry.getValue());
        }
        if (!this.headers.containsKey("typ")) {
            jws.setHeader("typ", "JWT");
        }
        if ((algorithm = (String)this.headers.get("alg")) == null) {
            algorithm = JwtSignatureImpl.keyAlgorithm(this.headers, signingKey);
            jws.setAlgorithmHeaderValue(algorithm);
        }
        if ("none".equals(algorithm)) {
            jws.setAlgorithmConstraints(AlgorithmConstraints.ALLOW_ONLY_NONE);
        }
        jws.setPayload(this.claims.toJson());
        jws.setKey(signingKey);
        try {
            return jws.getCompactSerialization();
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signJwtTokenFailed(ex.getMessage(), ex);
        }
    }

    static String keyAlgorithm(Map<String, Object> headers, Key signingKey) {
        String alg = (String)headers.get("alg");
        if (signingKey instanceof RSAPrivateKey) {
            if (alg == null) {
                return SignatureAlgorithm.RS256.name();
            }
            if (alg.startsWith("RS")) {
                return alg;
            }
        } else if (signingKey instanceof ECPrivateKey) {
            if (alg == null) {
                return SignatureAlgorithm.ES256.name();
            }
            if (alg.startsWith("ES")) {
                return alg;
            }
        } else if (signingKey instanceof SecretKey) {
            if (alg == null) {
                return SignatureAlgorithm.HS256.name();
            }
            if (alg.startsWith("HS")) {
                return alg;
            }
        }
        throw ImplMessages.msg.unsupportedSignatureAlgorithm(signingKey.getAlgorithm());
    }

    static String getKeyLocationFromConfig() {
        String keyLocation = JwtBuildUtils.getConfigProperty("smallrye.jwt.sign.key-location", String.class);
        if (keyLocation == null) {
            throw ImplMessages.msg.signKeyLocationNotConfigured();
        }
        return keyLocation;
    }

    Key getSigningKeyFromKeyLocation(String keyLocation) {
        try {
            Key key = KeyUtils.readSigningKey((String)keyLocation, (String)((String)this.headers.get("kid")));
            if (key == null) {
                throw ImplMessages.msg.signingKeyCanNotBeLoadedFromLocation(keyLocation);
            }
            return key;
        }
        catch (Exception ex) {
            throw ImplMessages.msg.signingKeyCanNotBeLoadedFromLocation(keyLocation);
        }
    }
}

