/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.spi;

import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.spi.SpiMessages;
import jakarta.json.JsonObject;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.microprofile.jwt.JsonWebToken;

public abstract class JwtProvider {
    private static final String DEFAULT_JWT_PROVIDER = "io.smallrye.jwt.build.impl.JwtProviderImpl";
    private static volatile JwtProvider provider;

    protected JwtProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JwtProvider provider() {
        if (provider != null) return provider;
        Class<JwtProvider> clazz = JwtProvider.class;
        synchronized (JwtProvider.class) {
            if (provider != null) return provider;
            provider = JwtProvider.getProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    private static JwtProvider getProvider() {
        ServiceLoader<JwtProvider> loader = ServiceLoader.load(JwtProvider.class);
        Iterator<JwtProvider> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        try {
            return (JwtProvider)Class.forName(DEFAULT_JWT_PROVIDER).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw SpiMessages.msg.providerNotFound(DEFAULT_JWT_PROVIDER, ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw SpiMessages.msg.providerClassCannotBeAccessed(DEFAULT_JWT_PROVIDER, ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw SpiMessages.msg.providerCannotBeInstantiated(DEFAULT_JWT_PROVIDER, ex.getMessage(), ex);
        }
    }

    public abstract JwtClaimsBuilder claims();

    public abstract JwtClaimsBuilder claims(Map<String, Object> var1);

    public abstract JwtClaimsBuilder claims(JsonObject var1);

    public abstract JwtClaimsBuilder claims(String var1);

    public abstract JwtClaimsBuilder claims(JsonWebToken var1);
}

