/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class JWTSecurityContext
implements SecurityContext {
    private SecurityContext delegate;
    private JsonWebToken principal;

    JWTSecurityContext(SecurityContext delegate, JsonWebToken principal) {
        this.delegate = delegate;
        this.principal = principal;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.principal.getGroups().contains(role);
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public String getAuthenticationScheme() {
        return this.delegate.getAuthenticationScheme();
    }
}

