/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.principal.AbstractKeyLocationResolver;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class KeyLocationResolver
extends AbstractKeyLocationResolver
implements VerificationKeyResolver {
    public KeyLocationResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        super(authContextInfo);
        try {
            this.initializeKeyContent();
        }
        catch (Exception e) {
            KeyLocationResolver.reportLoadKeyException(authContextInfo.getPublicKeyContent(), authContextInfo.getPublicKeyLocation(), e);
        }
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        KeyLocationResolver.verifyKid((JsonWebStructure)jws, this.authContextInfo.getTokenKeyId());
        if (this.key != null) {
            return this.key;
        }
        Key theKey = this.tryAsVerificationJwk(jws);
        if (theKey == null) {
            KeyLocationResolver.reportUnresolvableKeyException(this.authContextInfo.getPublicKeyContent(), this.authContextInfo.getPublicKeyLocation());
        }
        return theKey;
    }

    private Key tryAsVerificationJwk(JsonWebSignature jws) throws UnresolvableKeyException {
        JsonWebKey jwk = super.tryAsJwk((JsonWebStructure)jws, this.authContextInfo.getSignatureAlgorithm().getAlgorithm());
        if (jwk != null) {
            return ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPublicKey();
        }
        return null;
    }

    protected void initializeKeyContent() throws Exception {
        JsonWebKey jwk;
        String content;
        if (this.isHttpsJwksInitialized(this.authContextInfo.getPublicKeyLocation())) {
            return;
        }
        String string = content = this.authContextInfo.getPublicKeyContent() != null ? this.authContextInfo.getPublicKeyContent() : this.readKeyContent(this.authContextInfo.getPublicKeyLocation());
        if (this.mayBeFormat(KeyFormat.PEM_KEY)) {
            this.key = KeyLocationResolver.tryAsPEMPublicKey(content, this.authContextInfo.getSignatureAlgorithm());
            if (this.key != null || this.isFormat(KeyFormat.PEM_KEY)) {
                return;
            }
        }
        if (this.mayBeFormat(KeyFormat.PEM_CERTIFICATE)) {
            this.key = KeyLocationResolver.tryAsPEMCertificate(content);
            if (this.key != null || this.isFormat(KeyFormat.PEM_CERTIFICATE)) {
                return;
            }
        }
        if ((jwk = this.loadFromJwk(content, this.authContextInfo.getTokenKeyId(), this.authContextInfo.getSignatureAlgorithm().getAlgorithm())) != null) {
            this.key = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPublicKey();
        }
    }

    static PublicKey tryAsPEMPublicKey(String content, SignatureAlgorithm algo) {
        PrincipalLogging.log.checkKeyContentIsBase64EncodedPEMKey();
        PublicKey key = null;
        try {
            key = KeyUtils.decodePublicKey(content, algo);
            PrincipalLogging.log.keyCreatedFromEncodedPEMKey();
        }
        catch (Exception e) {
            PrincipalLogging.log.keyContentIsNotValidEncodedPEMKey(e);
        }
        return key;
    }

    static PublicKey tryAsPEMCertificate(String content) {
        PrincipalLogging.log.checkKeyContentIsBase64EncodedPEMCertificate();
        PublicKey key = null;
        try {
            key = KeyUtils.decodeCertificate(content);
            PrincipalLogging.log.publicKeyCreatedFromEncodedPEMCertificate();
        }
        catch (Exception e) {
            PrincipalLogging.log.keyContentIsNotValidEncodedPEMCertificate(e);
        }
        return key;
    }
}

