package io.smallrye.jwt.auth.cdi;

import java.util.Locale;
import javax.enterprise.inject.spi.Annotated;
import java.io.Serializable;
import java.util.Optional;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class CDILogging_$logger extends DelegatingBasicLogger implements CDILogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CDILogging_$logger.class.getName();
    public CDILogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void getValue(final String name) {
        super.log.logf(FQCN, DEBUG, null, getValue$str(), name);
    }
    protected String getValue$str() {
        return "SRJWT12000: getValue(%s), null JsonWebToken";
    }
    @Override
    public final void failedToFindClaim(final String name) {
        super.log.logf(FQCN, DEBUG, null, failedToFindClaim$str(), name);
    }
    protected String failedToFindClaim$str() {
        return "SRJWT12001: Failed to find Claim for: %s";
    }
    @Override
    public final void getValueResult(final String name, final boolean isOptional, final Optional claimValue) {
        super.log.logf(FQCN, DEBUG, null, getValueResult$str(), name, isOptional, claimValue);
    }
    protected String getValueResult$str() {
        return "SRJWT12002: getValue(%s), isOptional=%s, claimValue=%s";
    }
    @Override
    public final void jsonValueProducer(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, jsonValueProducer$str(), injectionPoint);
    }
    protected String jsonValueProducer$str() {
        return "SRJWT12003: JsonValueProducer(%s).produce";
    }
    @Override
    public final void getOptionalString(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getOptionalString$str(), injectionPoint);
    }
    protected String getOptionalString$str() {
        return "SRJWT12004: getOptionalString(%s)";
    }
    @Override
    public final void getOptionalStringSet(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getOptionalStringSet$str(), injectionPoint);
    }
    protected String getOptionalStringSet$str() {
        return "SRJWT12005: getOptionalStringSet(%s)";
    }
    @Override
    public final void getOptionalLong(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getOptionalLong$str(), injectionPoint);
    }
    protected String getOptionalLong$str() {
        return "SRJWT12006: getOptionalLong(%s)";
    }
    @Override
    public final void getOptionalBoolean(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getOptionalBoolean$str(), injectionPoint);
    }
    protected String getOptionalBoolean$str() {
        return "SRJWT12007: getOptionalBoolean(%s)";
    }
    @Override
    public final void addTypeToClaimProducer(final Annotated annotated) {
        super.log.logf(FQCN, DEBUG, null, addTypeToClaimProducer$str(), annotated);
    }
    protected String addTypeToClaimProducer$str() {
        return "SRJWT12008: addTypeToClaimProducer(%s)";
    }
    @Override
    public final void checkingProviderClaim(final String claimName, final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, checkingProviderClaim$str(), claimName, injectionPoint);
    }
    protected String checkingProviderClaim$str() {
        return "SRJWT12009: Checking Provider Claim(%s), ip: %s";
    }
    @Override
    public final void pip(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, pip$str(), injectionPoint);
    }
    protected String pip$str() {
        return "SRJWT12010: pip: %s";
    }
    @Override
    public final void getClaimAsSet(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getClaimAsSet$str(), injectionPoint);
    }
    protected String getClaimAsSet$str() {
        return "SRJWT12011: getClaimAsSet(%s)";
    }
    @Override
    public final void getClaimAsString(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getClaimAsString$str(), injectionPoint);
    }
    protected String getClaimAsString$str() {
        return "SRJWT12012: getClaimAsString(%s)";
    }
    @Override
    public final void getClaimAsLong(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getClaimAsLong$str(), injectionPoint);
    }
    protected String getClaimAsLong$str() {
        return "SRJWT12013: getClaimAsLong(%s)";
    }
    @Override
    public final void getClaimAsDouble(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getClaimAsDouble$str(), injectionPoint);
    }
    protected String getClaimAsDouble$str() {
        return "SRJWT12014: getClaimAsDouble(%s)";
    }
    @Override
    public final void getClaimAsBoolean(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getClaimAsBoolean$str(), injectionPoint);
    }
    protected String getClaimAsBoolean$str() {
        return "SRJWT12015: getClaimAsBoolean(%s)";
    }
    @Override
    public final void getOptionalValue(final InjectionPoint injectionPoint) {
        super.log.logf(FQCN, DEBUG, null, getOptionalValue$str(), injectionPoint);
    }
    protected String getOptionalValue$str() {
        return "SRJWT12016: getOptionalValue(%s)";
    }
    @Override
    public final void beforeBeanDiscovery(final BeanManager beanManager) {
        super.log.logf(FQCN, DEBUG, null, beforeBeanDiscovery$str(), beanManager);
    }
    protected String beforeBeanDiscovery$str() {
        return "SRJWT12017: beforeBeanDiscovery(%s)";
    }
    @Override
    public final void jwtHttpAuthenticationMechanismRegistered() {
        super.log.logf(FQCN, DEBUG, null, jwtHttpAuthenticationMechanismRegistered$str());
    }
    protected String jwtHttpAuthenticationMechanismRegistered$str() {
        return "SRJWT12018: EE Security is available, JWTHttpAuthenticationMechanism has been registered";
    }
    @Override
    public final void jwtHttpAuthenticationMechanismNotRegistered() {
        super.log.logf(FQCN, INFO, null, jwtHttpAuthenticationMechanismNotRegistered$str());
    }
    protected String jwtHttpAuthenticationMechanismNotRegistered$str() {
        return "SRJWT12019: EE Security is available, JWTHttpAuthenticationMechanism has been registered";
    }
    @Override
    public final void addedType(final String name) {
        super.log.logf(FQCN, DEBUG, null, addedType$str(), name);
    }
    protected String addedType$str() {
        return "SRJWT12020: Added type: %s";
    }
}
