package io.smallrye.jwt.auth.jaxrs;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class JAXRSLogging_$logger extends DelegatingBasicLogger implements JAXRSLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JAXRSLogging_$logger.class.getName();
    public JAXRSLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void success() {
        super.log.logf(FQCN, DEBUG, null, success$str());
    }
    protected String success$str() {
        return "SRJWT10000: Success";
    }
    @Override
    public final void unableParseJWT(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, unableParseJWT$str());
    }
    protected String unableParseJWT$str() {
        return "SRJWT10001: Unable to parse/validate JWT";
    }
    @Override
    public final void eeSecurityNotInUseButRegistered(final String authenticationFilterName) {
        super.log.logf(FQCN, DEBUG, null, eeSecurityNotInUseButRegistered$str(), authenticationFilterName);
    }
    protected String eeSecurityNotInUseButRegistered$str() {
        return "SRJWT10002: EE Security is not in use, %s has been registered";
    }
    @Override
    public final void mpJWTLoginConfigPresent(final String className) {
        super.log.logf(FQCN, DEBUG, null, mpJWTLoginConfigPresent$str(), className);
    }
    protected String mpJWTLoginConfigPresent$str() {
        return "SRJWT10003: MP-JWT LoginConfig present, %s is enabled";
    }
    @Override
    public final void mpJWTLoginConfigNotFound(final String className) {
        super.log.logf(FQCN, INFO, null, mpJWTLoginConfigNotFound$str(), className);
    }
    protected String mpJWTLoginConfigNotFound$str() {
        return "SRJWT10004: LoginConfig not found on Application class, %s will not be enabled";
    }
}
