/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth;

import io.smallrye.jwt.auth.AuthLogging;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;

public abstract class AbstractBearerTokenExtractor {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String COOKIE_HEADER = "Cookie";
    protected static final String BEARER = "Bearer";
    protected static final String BEARER_SCHEME_PREFIX = "Bearer ";
    private final JWTAuthContextInfo authContextInfo;

    protected AbstractBearerTokenExtractor(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public String getBearerToken() {
        String bearerValue;
        String tokenHeaderName = this.authContextInfo.getTokenHeader();
        boolean fallbackToHeader = this.authContextInfo.isAlwaysCheckAuthorization();
        AuthLogging.log.tokenHeaderName(tokenHeaderName);
        if (COOKIE_HEADER.equals(tokenHeaderName)) {
            String intermediateBearerValue = this.getBearerTokenCookie();
            bearerValue = intermediateBearerValue == null && fallbackToHeader ? this.getBearerTokenAuthHeader() : intermediateBearerValue;
        } else if (AUTHORIZATION_HEADER.equals(tokenHeaderName)) {
            bearerValue = this.getBearerTokenAuthHeader();
        } else {
            String customHeaderValue = this.getHeaderValue(tokenHeaderName);
            if (customHeaderValue == null) {
                AuthLogging.log.headerIsNull(tokenHeaderName);
            } else {
                String customHeaderSchemeValue = this.getTokenWithConfiguredScheme(customHeaderValue);
                if (customHeaderSchemeValue != null) {
                    customHeaderValue = customHeaderSchemeValue;
                }
            }
            bearerValue = customHeaderValue;
        }
        return bearerValue;
    }

    private String getBearerTokenCookie() {
        String tokenCookieName = this.authContextInfo.getTokenCookie();
        if (tokenCookieName == null) {
            tokenCookieName = BEARER;
        }
        AuthLogging.log.tokenCookieName(tokenCookieName);
        String bearerValue = this.getCookieValue(tokenCookieName);
        if (bearerValue == null) {
            AuthLogging.log.cookieIsNull(tokenCookieName);
        }
        return bearerValue;
    }

    private String getBearerTokenAuthHeader() {
        String bearerValue;
        String tokenHeader = this.getHeaderValue(AUTHORIZATION_HEADER);
        if (tokenHeader != null) {
            String token = this.getTokenWithConfiguredScheme(tokenHeader);
            if (token != null) {
                bearerValue = token;
            } else {
                AuthLogging.log.authHeaderDoesNotContainBearerPrefix();
                bearerValue = null;
            }
        } else {
            AuthLogging.log.authHeaderIsNull();
            bearerValue = null;
        }
        return bearerValue;
    }

    private String getTokenWithConfiguredScheme(String tokenHeader) {
        for (String scheme : this.authContextInfo.getTokenSchemes()) {
            String schemePrefix = scheme + " ";
            if (!AbstractBearerTokenExtractor.isTokenScheme(tokenHeader, schemePrefix)) continue;
            return tokenHeader.substring(schemePrefix.length());
        }
        return null;
    }

    private static boolean isTokenScheme(String headerValue, String schemePrefix) {
        if (headerValue.length() < schemePrefix.length()) {
            return false;
        }
        String scheme = headerValue.substring(0, schemePrefix.length());
        return schemePrefix.equalsIgnoreCase(scheme);
    }

    protected abstract String getHeaderValue(String var1);

    protected abstract String getCookieValue(String var1);
}

