/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.config.generator;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.MetadataKey;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.ServiceRegistrar;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.config.LoadBalancerAttribute;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.api.config.ServiceDiscoveryAttribute;
import io.smallrye.stork.api.config.ServiceRegistrarAttribute;
import io.smallrye.stork.api.config.ServiceRegistrarConfig;
import io.smallrye.stork.spi.StorkInfrastructure;
import io.smallrye.stork.spi.internal.LoadBalancerLoader;
import io.smallrye.stork.spi.internal.ServiceDiscoveryLoader;
import io.smallrye.stork.spi.internal.ServiceRegistrarLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ConfigClassWriter {
    private static final String SERVICES_DIR = "META-INF/services/";
    private final ProcessingEnvironment environment;
    private static final String IMPORT_STATEMENT = "import %s;";

    public ConfigClassWriter(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    public String createConfig(Element element, String type, LoadBalancerAttribute[] attributes) throws IOException {
        return this.createConfig(element, type, "", String.format(" Configuration for the {@code %s} LoadBalancer.", element.getSimpleName()), (out, cn) -> this.writeLoadBalancerAttributes((String)cn, attributes, (PrintWriter)out));
    }

    public String createConfig(Element element, String type, ServiceDiscoveryAttribute[] attributes) throws IOException {
        return this.createConfig(element, type, "", String.format(" Configuration for the {@code %s} ServiceDiscovery.", element.getSimpleName()), (out, cn) -> this.writeServiceDiscoveryAttributes((String)cn, attributes, (PrintWriter)out));
    }

    public String createConfig(Element element, String type, ServiceRegistrarAttribute[] attributes) throws IOException {
        return this.createConfig(element, type, "Registrar", String.format(" Configuration for the {@code %s} ServiceRegistrar.", element.getSimpleName()), (out, cn) -> this.writeServiceRegistrarAttributes((String)cn, attributes, (PrintWriter)out));
    }

    public String createLoadBalancerLoader(Element element, String configClassName, String type) throws IOException {
        String providerClassName = element.toString();
        String className = providerClassName + "Loader";
        String classPackage = this.getPackage(element);
        String simpleClassName = String.valueOf(element.getSimpleName()) + "Loader";
        JavaFileObject javaFile = this.environment.getFiler().createSourceFile(className, new Element[0]);
        javaFile.delete();
        try (PrintWriter out = new PrintWriter(javaFile.openWriter());){
            ConfigClassWriter.writePackageDeclaration(classPackage, out);
            this.writeImportStatement(configClassName, out);
            this.writeImportStatement(providerClassName, out);
            this.writeImportStatement(LoadBalancer.class, out);
            this.writeImportStatement(ConfigWithType.class, out);
            this.writeImportStatement(ServiceDiscovery.class, out);
            this.writeImportStatement(CDI.class, out);
            this.writeImportStatement(ApplicationScoped.class, out);
            this.writeClassDeclaration(String.format("%s implements %s", simpleClassName, LoadBalancerLoader.class.getName()), "LoadBalancerLoader for " + providerClassName, out);
            ConfigClassWriter.generateConstructor(providerClassName, simpleClassName, out);
            out.println("   @Override");
            out.println("   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {");
            out.println(String.format("      %s typedConfig = new %s(config.parameters());", configClassName, configClassName));
            out.println("      return provider.createLoadBalancer(typedConfig, serviceDiscovery);");
            out.println("   }");
            this.writeTypeMethod(type, out);
            out.println("}");
        }
        return className;
    }

    private static void generateConstructor(String providerClassName, String simpleClassName, PrintWriter out) {
        out.println(String.format("   private final %s provider;", providerClassName));
        out.println("   public " + simpleClassName + "() {");
        out.println("       " + providerClassName + " actual = null;");
        out.println("       try {");
        out.println("          actual = CDI.current().select(" + providerClassName + ".class).get();");
        out.println("       } catch(Exception e) { ");
        out.println("          // Use direct instantiation");
        out.println("          actual = new " + providerClassName + "();");
        out.println("       } ");
        out.println("       this.provider = actual;");
        out.println("   }");
        out.println("");
    }

    public String createServiceDiscoveryLoader(Element element, String configClassName, String type) throws IOException {
        String providerClassName = element.toString();
        String className = providerClassName + "Loader";
        String classPackage = this.getPackage(element);
        String simpleClassName = String.valueOf(element.getSimpleName()) + "Loader";
        JavaFileObject javaFile = this.environment.getFiler().createSourceFile(className, new Element[0]);
        javaFile.delete();
        try (PrintWriter out = new PrintWriter(javaFile.openWriter());){
            ConfigClassWriter.writePackageDeclaration(classPackage, out);
            this.writeImportStatement(configClassName, out);
            this.writeImportStatement(providerClassName, out);
            this.writeImportStatement(ServiceDiscovery.class, out);
            this.writeImportStatement(ConfigWithType.class, out);
            this.writeImportStatement(ServiceConfig.class, out);
            this.writeImportStatement(StorkInfrastructure.class, out);
            this.writeImportStatement(CDI.class, out);
            this.writeImportStatement(ApplicationScoped.class, out);
            this.writeClassDeclaration(String.format("%s implements %s", simpleClassName, ServiceDiscoveryLoader.class.getName()), "ServiceDiscoveryLoader for {@link " + providerClassName + "}", out);
            ConfigClassWriter.generateConstructor(providerClassName, simpleClassName, out);
            out.println("   @Override");
            out.println("   public ServiceDiscovery createServiceDiscovery(ConfigWithType config, String serviceName,");
            out.println("              ServiceConfig serviceConfig, StorkInfrastructure storkInfrastructure) {");
            out.println(String.format("      %s typedConfig = new %s(config.parameters());", configClassName, configClassName));
            out.println("      return provider.createServiceDiscovery(typedConfig, serviceName, serviceConfig, storkInfrastructure);");
            out.println("   }");
            this.writeTypeMethod(type, out);
            out.println("}");
        }
        return className;
    }

    public String createServiceRegistrarLoader(Element element, String metadataKey, String configClassName, String type) throws IOException {
        String registrarProviderClass = element.toString();
        String className = registrarProviderClass + "Loader";
        String classPackage = this.getPackage(element);
        String simpleClassName = String.valueOf(element.getSimpleName()) + "Loader";
        String metadataKeyName = metadataKey.substring(metadataKey.lastIndexOf(46) + 1);
        JavaFileObject javaFile = this.environment.getFiler().createSourceFile(className, new Element[0]);
        javaFile.delete();
        try (PrintWriter out = new PrintWriter(javaFile.openWriter());){
            ConfigClassWriter.writePackageDeclaration(classPackage, out);
            this.writeImportStatement(configClassName, out);
            this.writeImportStatement(registrarProviderClass, out);
            this.writeImportStatement(ConfigWithType.class, out);
            this.writeImportStatement(ServiceRegistrar.class, out);
            this.writeImportStatement(ServiceRegistrarConfig.class, out);
            this.writeImportStatement(StorkInfrastructure.class, out);
            this.writeImportStatement(CDI.class, out);
            this.writeImportStatement(metadataKey, out);
            this.writeImportStatement(MetadataKey.class, out);
            this.writeImportStatement(ApplicationScoped.class, out);
            this.writeClassDeclaration(String.format("%s implements %s<%s>", simpleClassName, ServiceRegistrarLoader.class.getName(), metadataKeyName), "ServiceRegistrarLoader for {@link " + registrarProviderClass + "}", out);
            ConfigClassWriter.generateConstructor(registrarProviderClass, simpleClassName, out);
            out.println("   @Override");
            out.println(String.format("   public ServiceRegistrar<%s> createServiceRegistrar(ConfigWithType config, String serviceName, ", metadataKeyName));
            out.println("              StorkInfrastructure storkInfrastructure) {");
            out.println(String.format("      %s typedConfig = new %s(config.parameters());", configClassName, configClassName));
            out.println("      return provider.createServiceRegistrar(typedConfig, serviceName, storkInfrastructure);");
            out.println("   }");
            this.writeTypeMethod(type, out);
            out.println("}");
        }
        return className;
    }

    private void writeServiceDiscoveryAttributes(String simpleClassName, ServiceDiscoveryAttribute[] attributes, PrintWriter out) {
        for (ServiceDiscoveryAttribute attribute : attributes) {
            this.writeAttribute(out, simpleClassName, attribute.name(), attribute.description(), attribute.defaultValue());
        }
    }

    private void writeServiceRegistrarAttributes(String simpleClassName, ServiceRegistrarAttribute[] attributes, PrintWriter out) {
        for (ServiceRegistrarAttribute attribute : attributes) {
            this.writeAttribute(out, simpleClassName, attribute.name(), attribute.description(), attribute.defaultValue());
        }
    }

    private void writeLoadBalancerAttributes(String simpleClassName, LoadBalancerAttribute[] attributes, PrintWriter out) {
        for (LoadBalancerAttribute attribute : attributes) {
            this.writeAttribute(out, simpleClassName, attribute.name(), attribute.description(), attribute.defaultValue());
        }
    }

    public String createConfig(Element element, String type, String suffix, String comment, BiConsumer<PrintWriter, String> attributesWriter) throws IOException {
        String sanitized = this.toCamelCase(type);
        String classPackage = this.getPackage(element);
        String simpleClassName = sanitized + suffix + "Configuration";
        String className = classPackage + "." + simpleClassName;
        JavaFileObject file = this.environment.getFiler().createSourceFile(className, new Element[0]);
        file.delete();
        try (PrintWriter out = new PrintWriter(file.openWriter());){
            ConfigClassWriter.writePackageDeclaration(classPackage, out);
            this.writeImportStatement(Collections.class, out);
            this.writeImportStatement(HashMap.class, out);
            this.writeImportStatement(Map.class, out);
            this.writeImportStatement(ConfigWithType.class, out);
            this.writeConfigClassDeclaration(simpleClassName, comment, out);
            this.writeConfigMapRelatedStuff(simpleClassName, out);
            out.println();
            this.writeTypeMethod(type, out);
            out.println();
            this.writeParametersMethod(out);
            out.println();
            this.writeExtendMethod(simpleClassName, out);
            attributesWriter.accept(out, simpleClassName);
            out.println('}');
        }
        return className;
    }

    private void writeAttribute(PrintWriter out, String simpleClassName, String name, String description, String defaultValue) {
        if (defaultValue.equals("__$$_DEFAULT_VALUE_$$__")) {
            defaultValue = null;
        }
        out.println();
        out.println("   /**");
        if (defaultValue != null) {
            out.println(String.format("    * %s By default: %s", description, defaultValue));
            out.println("    *");
            out.println("    * @return the configured " + name + ", {@code " + defaultValue + "} if not set");
        } else {
            out.println(String.format("    * %s", description));
            out.println("    *");
            out.println("    * @return the configured " + name + ", @{code null} if not set");
        }
        out.println("    */");
        out.println(String.format("   public String get%s() {", this.toCamelCase(name)));
        if (defaultValue != null) {
            out.println(String.format("      String result = parameters.get(\"%s\");", name));
            out.println(String.format("      return result == null ? \"%s\" : result;", defaultValue));
        } else {
            out.println(String.format("      return parameters.get(\"%s\");", name));
        }
        out.println("   }");
        out.println();
        out.println("   /**");
        if (defaultValue != null) {
            out.println(String.format("    * Set the '%s' attribute. Default is %s.", name, defaultValue));
        } else {
            out.println(String.format("    * Set the '%s' attribute.", name));
        }
        out.println("    * ");
        out.println("    * @param value the value for " + name);
        out.println("    * @return the current " + simpleClassName + " to chain calls");
        out.println("    */");
        out.println(String.format("   public %s with%s(String value) {", simpleClassName, this.toCamelCase(name)));
        out.println(String.format("      return extend(\"%s\", value);", name));
        out.println("   }");
    }

    private void writeConfigMapRelatedStuff(String simpleClassName, PrintWriter out) {
        out.println("   private final Map<String, String> parameters;");
        out.println();
        out.println("   /**");
        out.println("    * Creates a new " + simpleClassName);
        out.println("    *");
        out.println("    * @param params the parameters, must not be {@code null}");
        out.println("    */");
        out.println(String.format("   public %s(Map<String, String> params) {", simpleClassName));
        out.println("      parameters = Collections.unmodifiableMap(params);");
        out.println("   }");
        out.println();
        out.println("   /**");
        out.println("    * Creates a new " + simpleClassName);
        out.println("    */");
        out.println(String.format("   public %s() {", simpleClassName));
        out.println("      parameters = Collections.emptyMap();");
        out.println("   }");
    }

    private void writeExtendMethod(String simpleClassName, PrintWriter out) {
        out.println(String.format("   private %s extend(String key, String value) {", simpleClassName));
        out.println("      Map<String, String> copy = new HashMap<>(parameters);");
        out.println("      copy.put(key, value);");
        out.println(String.format("      return new %s(copy);", simpleClassName));
        out.println("   }");
    }

    private void writeTypeMethod(String type, PrintWriter out) {
        out.println();
        out.println("  /**");
        out.println("   * @return the type");
        out.println("   */");
        out.println("   @Override");
        out.println("   public String type() {");
        out.println("      return \"" + type + "\";");
        out.println("   }");
    }

    private void writeParametersMethod(PrintWriter out) {
        out.println();
        out.println("   /**");
        out.println("    * @return the parameters");
        out.println("    */");
        out.println("   @Override");
        out.println("   public Map<String, String> parameters() {");
        out.println("      return parameters;");
        out.println("   }");
    }

    private String toCamelCase(String attribute) {
        StringBuilder result = new StringBuilder();
        boolean capitalized = true;
        for (char c : attribute.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                capitalized = true;
                continue;
            }
            result.append(capitalized ? Character.toUpperCase(c) : c);
            capitalized = false;
        }
        return result.toString();
    }

    static void writePackageDeclaration(String packageName, PrintWriter out) {
        if (packageName != null) {
            out.print("package ");
            out.print(packageName);
            out.println(";");
            out.println();
        }
    }

    private void writeConfigClassDeclaration(String simpleName, String comment, PrintWriter out) {
        out.println();
        out.println("/**");
        out.println(" * " + comment);
        out.println(" */");
        out.println(String.format(" public class %s implements %s{", simpleName, ConfigWithType.class.getName()));
    }

    private void writeClassDeclaration(String simpleName, String comment, PrintWriter out) {
        out.println();
        out.println("/**");
        out.println(" * " + comment);
        out.println(" */");
        out.println(" @ApplicationScoped");
        out.println(String.format(" public class %s {", simpleName));
    }

    private String getPackage(Element classElement) {
        String className = classElement.toString();
        ElementKind parent = classElement.getEnclosingElement().getKind();
        if (parent != ElementKind.PACKAGE) {
            throw new IllegalArgumentException("Only top level classes (i.e. no inner classes) can be used as LoadBalancerProvider and ServiceDiscoveryProvider implementations, found " + className + " which is contained by a " + String.valueOf((Object)parent));
        }
        int indexOfLastDot = className.lastIndexOf(46);
        if (indexOfLastDot > 0) {
            return className.substring(0, indexOfLastDot);
        }
        throw new IllegalArgumentException("Invalid class name, load balancer and service provider classes cannot be in the default package");
    }

    public void createServiceLoaderFile(String interfaceName, Set<String> loaders) throws IOException {
        FileObject loaderFile = this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", SERVICES_DIR + interfaceName, new Element[0]);
        loaderFile.delete();
        try (PrintWriter out = new PrintWriter(loaderFile.openWriter());){
            for (String loader : loaders) {
                out.println(loader);
            }
        }
    }

    private void writeImportStatement(String className, PrintWriter out) {
        out.println(String.format(IMPORT_STATEMENT, className));
    }

    private void writeImportStatement(Class<?> clazz, PrintWriter out) {
        this.writeImportStatement(clazz.getName(), out);
    }
}

