/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.config.generator;

import io.smallrye.stork.api.config.LoadBalancerAttribute;
import io.smallrye.stork.api.config.ServiceDiscoveryAttribute;
import io.smallrye.stork.api.config.ServiceRegistrarAttribute;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class DocWriter {
    private static final String STORK_DOCS_DIR = "META-INF/stork-docs/";
    private final ProcessingEnvironment environment;

    public DocWriter(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    public void createAttributeTable(String serviceRegistrarType, ServiceRegistrarAttribute[] attributes) throws IOException {
        String attributeTableFile = serviceRegistrarType + "-sr-attributes.txt";
        FileObject loaderFile = this.createResourceFile(attributeTableFile);
        try (PrintWriter out = new PrintWriter(loaderFile.openWriter());){
            out.println(" | Attribute            | Mandatory  | Default Value      | Description  |");
            out.println(" |----------------------|------------|--------------------|--------------|");
            for (ServiceRegistrarAttribute attribute : attributes) {
                out.println(String.format("| `%s` | %s | %s | %s |", attribute.name(), attribute.required() ? "Yes" : "No", "__$$_DEFAULT_VALUE_$$__".equals(attribute.defaultValue()) ? "" : "`" + attribute.defaultValue() + "`", attribute.description()));
            }
        }
    }

    public void createAttributeTable(String serviceDiscoveryType, ServiceDiscoveryAttribute[] attributes) throws IOException {
        String attributeTableFile = serviceDiscoveryType + "-sd-attributes.txt";
        FileObject loaderFile = this.createResourceFile(attributeTableFile);
        try (PrintWriter out = new PrintWriter(loaderFile.openWriter());){
            out.println(" | Attribute            | Mandatory  | Default Value      | Description  |");
            out.println(" |----------------------|------------|--------------------|--------------|");
            for (ServiceDiscoveryAttribute attribute : attributes) {
                out.println(String.format("| `%s` | %s | %s | %s |", attribute.name(), attribute.required() ? "Yes" : "No", "__$$_DEFAULT_VALUE_$$__".equals(attribute.defaultValue()) ? "" : "`" + attribute.defaultValue() + "`", attribute.description()));
            }
        }
    }

    public void createAttributeTable(String loadBalancerType, LoadBalancerAttribute[] attributes) throws IOException {
        String attributeTableFile = loadBalancerType + "-lb-attributes.txt";
        FileObject loaderFile = this.createResourceFile(attributeTableFile);
        try (PrintWriter out = new PrintWriter(loaderFile.openWriter());){
            out.println(" | Attribute            | Mandatory  | Default Value      | Description  |");
            out.println(" |----------------------|------------|--------------------|--------------|");
            for (LoadBalancerAttribute attribute : attributes) {
                out.println(String.format("| `%s` | %s | %s | %s |", attribute.name(), attribute.required() ? "Yes" : "No", "__$$_DEFAULT_VALUE_$$__".equals(attribute.defaultValue()) ? "" : "`" + attribute.defaultValue() + "`", attribute.description()));
            }
        }
    }

    private FileObject createResourceFile(String fileName) throws IOException {
        FileObject loaderFile = this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", STORK_DOCS_DIR + fileName, new Element[0]);
        loaderFile.delete();
        return loaderFile;
    }
}

