/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.anchorrewrite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;

class AnchorRewriteScriptTag {
    private final Map<String, String> entries;

    AnchorRewriteScriptTag(Map<?, ?> entries) {
        this.entries = this.getValidEntries(entries);
    }

    private Map<String, String> getValidEntries(Map<?, ?> entries) {
        TreeMap validEntries = new TreeMap();
        entries.forEach((key, value) -> {
            if (!Objects.equals(key, value)) {
                validEntries.put(String.valueOf(key), String.valueOf(value));
            }
        });
        return Collections.unmodifiableMap(validEntries);
    }

    String getHtml() {
        if (this.entries.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder();
        html.append("<script type=\"application/json\" id=\"anchor-rewrite\">\n");
        html.append("{\n");
        Iterator<Map.Entry<String, String>> iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            html.append(this.jsonQuote(entry.getKey()));
            html.append(":");
            html.append(this.jsonQuote(entry.getValue()));
            html.append(iterator.hasNext() ? ",\n" : "\n");
        }
        html.append("}\n");
        html.append("</script>");
        return html.toString();
    }

    private String jsonQuote(String string) {
        return "\"" + string.replace("\"", "\\\"") + "\"";
    }

    static AnchorRewriteScriptTag fromPropertiesFile(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
        }
        return new AnchorRewriteScriptTag(properties);
    }
}

