/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.codetools;

import io.spring.asciidoctor.backend.codetools.FoldOption;
import io.spring.asciidoctor.backend.codetools.ListingContentConverter;
import io.spring.asciidoctor.backend.codetools.Options;
import io.spring.asciidoctor.backend.language.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentNode;

class FoldListingContentConverter
implements ListingContentConverter {
    FoldListingContentConverter() {
    }

    @Override
    public String convert(Block listingBlock, String content) {
        Options options = Options.get((Block)listingBlock, (String)"fold", FoldOption.class, (Enum[])FoldOption.DEFAULTS);
        Language language = Language.get((ContentNode)listingBlock);
        if (Language.isJavaLike(language)) {
            FoldBlocks foldBlocks;
            ArrayList<Folder> folders = new ArrayList<Folder>();
            if (options.has(FoldOption.IMPORTS)) {
                folders.add(new ImportsFolder());
            }
            if (options.has(FoldOption.TAGS)) {
                folders.add(new TagFolder("//", "@fold:on", "@fold:off"));
            }
            if ((foldBlocks = FoldBlocks.get(content, new Folders(folders))).isFoldable()) {
                return this.convert(foldBlocks);
            }
        }
        return content;
    }

    private String convert(FoldBlocks foldBlocks) {
        StringBuilder html = new StringBuilder();
        Iterator<FoldBlock> iterator = foldBlocks.iterator();
        while (iterator.hasNext()) {
            FoldBlock foldBlock = iterator.next();
            String whenFoldedContent = foldBlock.getWhenFoldedContent();
            if (whenFoldedContent != null && !whenFoldedContent.isEmpty()) {
                html.append("<span class=\"fold-block hide-when-unfolded\">");
                html.append(this.indentMatch(foldBlock, whenFoldedContent));
                html.append("\n\n");
                html.append("</span>");
            }
            html.append("<span class=\"fold-block");
            if (foldBlock.hasFolder()) {
                html.append(" hide-when-folded");
            }
            html.append("\">");
            this.writeLines(html, foldBlock, iterator.hasNext());
            html.append("</span>");
        }
        return html.toString();
    }

    private void writeLines(StringBuilder html, Iterable<String> lines, boolean endWithNewLine) {
        String lastLine = null;
        boolean writtenLine = false;
        for (String line : lines) {
            if (this.isBlankLine(line) && !writtenLine) continue;
            html.append(line);
            html.append("\n");
            writtenLine = true;
            lastLine = line;
        }
        html.append(!this.isBlankLine(lastLine) && endWithNewLine ? "\n" : "");
    }

    private boolean isBlankLine(String line) {
        return line != null && line.trim().isEmpty();
    }

    private String indentMatch(FoldBlock foldBlock, String line) {
        for (String blockLine : foldBlock) {
            if (this.isBlankLine(blockLine)) continue;
            StringBuilder indent = new StringBuilder();
            for (char ch : blockLine.toCharArray()) {
                if (!Character.isWhitespace(ch)) {
                    return indent + line;
                }
                indent.append(ch);
            }
        }
        return line;
    }

    private static class FoldBlock
    implements Iterable<String> {
        private final Folder folder;
        private final String foldStartLine;
        private List<String> lines;

        FoldBlock(Folder folder, String foldStartLine, List<String> lines) {
            this.folder = folder;
            this.foldStartLine = foldStartLine;
            this.lines = lines;
        }

        @Override
        public Iterator<String> iterator() {
            return this.lines.iterator();
        }

        boolean hasFolder() {
            return this.folder != null;
        }

        boolean hasLines() {
            return !this.lines.isEmpty();
        }

        String getWhenFoldedContent() {
            return this.folder != null ? this.folder.getWhenFoldedContent(this.foldStartLine) : null;
        }

        public String toString() {
            return this.lines.stream().collect(Collectors.joining("\n"));
        }
    }

    private static class FoldBlocks
    implements Iterable<FoldBlock> {
        private final List<FoldBlock> foldBlocks;

        FoldBlocks(Stream<FoldBlock> areas) {
            this.foldBlocks = Collections.unmodifiableList(areas.collect(Collectors.toList()));
        }

        boolean isFoldable() {
            return this.foldBlocks.stream().anyMatch(FoldBlock::hasFolder);
        }

        @Override
        public Iterator<FoldBlock> iterator() {
            return this.foldBlocks.iterator();
        }

        static FoldBlocks get(String content, Folders folders) {
            return FoldBlocks.get(content.split("\n\r?"), folders);
        }

        static FoldBlocks get(String[] lines, Folders folders) {
            ArrayList<FoldBlock> foldBlocks = new ArrayList<FoldBlock>();
            Folder folder = null;
            int start = 0;
            for (int i = 0; i < lines.length; ++i) {
                if (folder != null) {
                    if (!folder.isEnd(lines, i)) continue;
                    foldBlocks.add(FoldBlocks.createFoldArea(folder, lines, start, i));
                    start = i + 1;
                    folder = null;
                    continue;
                }
                folder = folders.get(lines, i);
                if (folder == null) continue;
                foldBlocks.add(FoldBlocks.createFoldArea(null, lines, start, i - 1));
                start = i;
            }
            if (start < lines.length) {
                foldBlocks.add(FoldBlocks.createFoldArea(folder, lines, start, lines.length - 1));
            }
            return new FoldBlocks(foldBlocks.stream().filter(FoldBlock::hasLines));
        }

        private static FoldBlock createFoldArea(Folder folder, String[] lines, int start, int end) {
            String foldStartLine = lines[start];
            int fromIndex = folder == null || folder.isStartConsumed() ? start : start + 1;
            int toIndex = folder == null || folder.isEndConsumed() ? end + 1 : end;
            List<String> blockLines = Collections.unmodifiableList(Arrays.asList(lines).subList(fromIndex, toIndex));
            return new FoldBlock(folder, foldStartLine, blockLines);
        }
    }

    private static class ImportsFolder
    implements Folder {
        private ImportsFolder() {
        }

        @Override
        public boolean isStart(String[] lines, int index) {
            return this.isImport(lines[index]);
        }

        @Override
        public boolean isEnd(String[] lines, int index) {
            if (index + 1 < lines.length) {
                String nextLine = lines[index + 1];
                return !nextLine.trim().isEmpty() && !this.isImport(nextLine);
            }
            return true;
        }

        private boolean isImport(String line) {
            return line.startsWith("import ");
        }

        @Override
        public boolean isStartConsumed() {
            return true;
        }

        @Override
        public boolean isEndConsumed() {
            return true;
        }
    }

    private static class TagFolder
    implements Folder {
        private final String prefix;
        private final String on;
        private final String off;

        TagFolder(String prefix, String on, String off) {
            this.prefix = prefix;
            this.on = on;
            this.off = off;
        }

        @Override
        public boolean isStart(String[] lines, int index) {
            return this.isPrefixed(lines[index]) && lines[index].contains(this.on);
        }

        @Override
        public boolean isEnd(String[] lines, int index) {
            return this.isPrefixed(lines[index]) && lines[index].contains(this.off);
        }

        private boolean isPrefixed(String line) {
            return line.trim().startsWith(this.prefix);
        }

        @Override
        public String getWhenFoldedContent(String foldStartLine) {
            return foldStartLine.substring(foldStartLine.indexOf(this.on) + this.on.length()).trim();
        }
    }

    private static interface Folder {
        public boolean isStart(String[] var1, int var2);

        public boolean isEnd(String[] var1, int var2);

        default public boolean isStartConsumed() {
            return false;
        }

        default public boolean isEndConsumed() {
            return false;
        }

        default public String getWhenFoldedContent(String line) {
            return null;
        }
    }

    private static class Folders {
        private final List<Folder> folders;

        Folders(List<Folder> folders) {
            this.folders = Collections.unmodifiableList(folders);
        }

        Folder get(String[] lines, int index) {
            for (Folder folder : this.folders) {
                if (!folder.isStart(lines, index)) continue;
                return folder;
            }
            return null;
        }
    }
}

