/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.codetools;

import io.spring.asciidoctor.backend.codetools.FoldOption;
import io.spring.asciidoctor.backend.codetools.ListingContentConverter;
import io.spring.asciidoctor.backend.codetools.Options;
import io.spring.asciidoctor.backend.language.Language;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.ContentNode;

class FoldRemovalListingContentConverter
implements ListingContentConverter {
    FoldRemovalListingContentConverter() {
    }

    @Override
    public String convert(Block listingBlock, String content) {
        Options options = Options.get((Block)listingBlock, (String)"fold", FoldOption.class, (Enum[])FoldOption.DEFAULTS);
        Language language = Language.get((ContentNode)listingBlock);
        if (Language.isJavaLike(language) && options.has(FoldOption.TAGS)) {
            return this.removeFoldTags(content);
        }
        return content;
    }

    private String removeFoldTags(String content) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        for (String line : lines = content.split("\n\r?")) {
            if (this.isFoldLine(line)) continue;
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    private boolean isFoldLine(String line) {
        return line.trim().startsWith("//") && line.contains("@fold:");
    }
}

