/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.codetools;

import io.spring.asciidoctor.backend.codetools.ListingContentConverter;
import java.util.Collections;
import java.util.List;
import org.asciidoctor.ast.Block;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.jruby.RubyObject;

public class ListingContentConverters {
    private final List<ListingContentConverter> converters;

    ListingContentConverters(List<ListingContentConverter> converters) {
        this.converters = Collections.unmodifiableList(converters);
    }

    RubyObject content(RubyObject node) {
        Block listingBlock = (Block)NodeConverter.createASTNode((Object)node);
        String content = (String)listingBlock.getContent();
        for (ListingContentConverter converter : this.converters) {
            content = content != null ? content : "";
            content = converter.convert(listingBlock, content);
        }
        return node.getRuntime().newString(content != null ? content : "");
    }
}

