/*
 * Decompiled with CFR 0.152.
 */
package io.spring.asciidoctor.backend.codetools;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.asciidoctor.ast.Block;

final class Options<E extends Enum<E>>
implements Iterable<E> {
    private final Set<Option> options;
    private final Set<E> active;

    private Options(Class<E> type, String value, boolean defaultWhenEmpty, E[] defaults) {
        this.options = this.parse(type, value, defaultWhenEmpty);
        this.active = this.getActive(type, this.options, (Enum[])defaults);
    }

    private Options(Class<E> type, Set<Option> options, E[] defaults) {
        this.options = options;
        this.active = this.getActive(type, this.options, (Enum[])defaults);
    }

    private Set<Option> parse(Class<E> type, String value, boolean defaultWhenEmpty) {
        if (value == null || value.isEmpty()) {
            return !defaultWhenEmpty ? Collections.emptySet() : Collections.singleton(new Option(OptionType.DEFAULT));
        }
        LinkedHashSet<Option> options = new LinkedHashSet<Option>();
        for (String optionValue : value.split("\\s")) {
            options.add(new Option(type, optionValue));
        }
        return Collections.unmodifiableSet(options);
    }

    private Set<E> getActive(Class<E> type, Set<Option> options, E[] defaults) {
        EnumSet active = EnumSet.noneOf(type);
        for (Option option : options) {
            if (option.getType() == OptionType.DEFAULT) {
                active.addAll(Arrays.asList(defaults));
            }
            if (option.getType() == OptionType.ALL) {
                active.addAll(EnumSet.allOf(type));
                continue;
            }
            if (option.getType() == OptionType.NONE) {
                active.clear();
                continue;
            }
            if (option.getType() == OptionType.ADD || option.getType() == OptionType.VALUE) {
                active.add(option.getValue());
                continue;
            }
            if (option.getType() != OptionType.REMOVE) continue;
            active.remove(option.getValue());
        }
        return Collections.unmodifiableSet(active);
    }

    Options<E> merge(Class<E> type, E[] defaults, Options<E> other) {
        if (super.hasAnyOptionOfType(OptionType.ALL, OptionType.NONE, OptionType.VALUE, OptionType.DEFAULT)) {
            return other;
        }
        LinkedHashSet<Option> options = new LinkedHashSet<Option>(this.options);
        options.addAll(other.options);
        return new Options(type, options, defaults);
    }

    private boolean hasAnyOptionOfType(OptionType ... optionTypes) {
        Predicate<OptionType> predicate = Arrays.asList(optionTypes)::contains;
        return this.options.stream().map(Option::getType).anyMatch(predicate);
    }

    boolean has(E option) {
        return this.active.contains(option);
    }

    @Override
    public Iterator<E> iterator() {
        return this.active.iterator();
    }

    static <E extends Enum<E>> Options<E> get(Block block, String name, Class<E> type, E[] defaults) {
        String documentAttribute = (String)block.getDocument().getAttribute((Object)name);
        String blockAttribute = (String)block.getAttribute((Object)name);
        return Options.parse((String)documentAttribute, (String)blockAttribute, type, defaults);
    }

    static <E extends Enum<E>> Options<E> parse(String documentAttribute, String blockAttribute, Class<E> type, E[] defaults) {
        Options documentOptions = new Options(type, documentAttribute, true, defaults);
        Options blockOptions = new Options(type, blockAttribute, false, defaults);
        return documentOptions.merge(type, (Enum[])defaults, blockOptions);
    }

    private static enum OptionType {
        VALUE,
        ADD,
        REMOVE,
        ALL,
        NONE,
        DEFAULT;

    }

    private class Option {
        private final OptionType type;
        private final E value;

        Option(Class<E> type, String value) {
            if (value.equalsIgnoreCase("all")) {
                this.type = OptionType.ALL;
                this.value = null;
            } else if (value.equalsIgnoreCase("none")) {
                this.type = OptionType.NONE;
                this.value = null;
            } else if (value.equalsIgnoreCase("default")) {
                this.type = OptionType.DEFAULT;
                this.value = null;
            } else if (value.startsWith("+")) {
                this.type = OptionType.ADD;
                this.value = this.parseValue(type, value.substring(1));
            } else if (value.startsWith("-")) {
                this.type = OptionType.REMOVE;
                this.value = this.parseValue(type, value.substring(1));
            } else {
                this.type = OptionType.VALUE;
                this.value = this.parseValue(type, value);
            }
        }

        Option(OptionType type) {
            this.type = type;
            this.value = null;
        }

        private E parseValue(Class<E> type, String value) {
            return Enum.valueOf(type, value.toUpperCase());
        }

        OptionType getType() {
            return this.type;
        }

        E getValue() {
            return this.value;
        }
    }
}

