/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.apache.maven.model.plugin;

import io.spring.gradle.dependencymanagement.org.apache.maven.model.Build;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Plugin;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.PluginExecution;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.PluginManagement;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblemCollector;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.plugin.PluginConfigurationExpander;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.util.xml.Xpp3Dom;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Build build = model.getBuild();
        if (build != null) {
            this.expand(build.getPlugins());
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                this.expand(pluginManagement.getPlugins());
            }
        }
    }

    private void expand(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
            if (pluginConfiguration == null) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom executionConfiguration = (Xpp3Dom)execution.getConfiguration();
                executionConfiguration = Xpp3Dom.mergeXpp3Dom(executionConfiguration, new Xpp3Dom(pluginConfiguration));
                execution.setConfiguration(executionConfiguration);
            }
        }
    }
}

