/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElementDelta;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import org.eclipse.core.resources.IResource;

public class DiscardWorkingCopyOperation
extends JavaModelOperation {
    public DiscardWorkingCopyOperation(IJavaElement workingCopy) {
        super(new IJavaElement[]{workingCopy});
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        CompilationUnit workingCopy = this.getWorkingCopy();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int useCount = manager.discardPerWorkingCopyInfo(workingCopy);
        if (useCount == 0) {
            IJavaProject javaProject = workingCopy.getJavaProject();
            if (" ".equals(javaProject.getElementName())) {
                manager.removePerProjectInfo((JavaProject)javaProject, true);
                manager.containerRemove(javaProject);
            }
            if (!workingCopy.isPrimary()) {
                JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                delta.removed(workingCopy);
                this.addDelta(delta);
                this.removeReconcileDelta(workingCopy);
            } else {
                IResource resource = workingCopy.getResource();
                if (resource != null) {
                    if (resource.isAccessible()) {
                        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                        delta.changed(workingCopy, 65536);
                        this.addDelta(delta);
                    } else {
                        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                        delta.removed(workingCopy, 65536);
                        this.addDelta(delta);
                    }
                }
            }
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

