/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTConverter;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AnnotationTypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ArrayType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.BindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Block;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.DefaultBindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Dimension;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ExpressionStatement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ImportDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Initializer;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.MemberRef;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.MethodRef;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.MethodRefParameter;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ModuleDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Name;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.NodeEventHandler;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.PackageDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.PrimitiveType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.QualifiedName;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimpleType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SingleVariableDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.StructuralPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.TagElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.TextElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Type;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.TypeDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.VariableDeclarationFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.WildcardType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.CompilationUnitDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFileConstants;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.CompilerOptions;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.Scanner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;

public final class AST {
    private static final Class[] AST_CLASS = new Class[]{AST.class};
    private static Map<String, Long> jdkLevelMap = AST.getLevelMapTable();
    private static Map<String, Integer> apiLevelMap = AST.getApiLevelMapTable();
    int apiLevel;
    private boolean previewEnabled;
    private int bits;
    private int defaultNodeFlag = 0;
    private int disableEvents = 0;
    private NodeEventHandler eventHandler = new NodeEventHandler();
    private final Object internalASTLock = new Object();
    private long modificationCount = 0L;
    private long originalModificationCount = 0L;
    private BindingResolver resolver = new BindingResolver();
    Scanner scanner;
    private final Object[] THIS_AST = new Object[]{this};

    public static CompilationUnit convertCompilationUnit(int level, CompilationUnitDeclaration compilationUnitDeclaration, Map options, boolean isResolved, io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CompilationUnit workingCopy, int reconcileFlags, IProgressMonitor monitor) {
        ASTConverter converter = new ASTConverter(options, isResolved, monitor);
        AST ast = AST.newAST(level, "enabled".equals(options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.problem.enablePreviewFeatures")));
        String sourceModeSetting = (String)options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.source");
        long sourceLevel = CompilerOptions.versionToJdkLevel(sourceModeSetting);
        if (sourceLevel == 0L) {
            sourceLevel = 0x2F0000L;
        }
        ast.scanner.sourceLevel = sourceLevel;
        String compliance = (String)options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.compliance");
        long complianceLevel = CompilerOptions.versionToJdkLevel(compliance);
        if (complianceLevel == 0L) {
            complianceLevel = sourceLevel;
        }
        ast.scanner.complianceLevel = complianceLevel;
        ast.scanner.previewEnabled = "enabled".equals(options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.problem.enablePreviewFeatures"));
        int savedDefaultNodeFlag = ast.getDefaultNodeFlag();
        ast.setDefaultNodeFlag(2);
        BindingResolver resolver = null;
        if (isResolved) {
            resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope, workingCopy.owner, new DefaultBindingResolver.BindingTables(), false, true);
            ((DefaultBindingResolver)resolver).isRecoveringBindings = (reconcileFlags & 4) != 0;
            ast.setFlag(Integer.MIN_VALUE);
        } else {
            resolver = new BindingResolver();
        }
        ast.setFlag(reconcileFlags);
        ast.setBindingResolver(resolver);
        converter.setAST(ast);
        CompilationUnit unit = converter.convert(compilationUnitDeclaration, workingCopy.getContents());
        unit.setLineEndTable(compilationUnitDeclaration.compilationResult.getLineSeparatorPositions());
        unit.setTypeRoot(workingCopy.originalFromClone());
        ast.setDefaultNodeFlag(savedDefaultNodeFlag);
        return unit;
    }

    public static AST newAST(int level, boolean previewEnabled) {
        return new AST(level, previewEnabled);
    }

    public AST() {
        this(JavaCore.getDefaultOptions());
    }

    private AST(int level, boolean previewEnabled) {
        this.previewEnabled = previewEnabled;
        switch (level) {
            case 2: 
            case 3: {
                this.apiLevel = level;
                this.scanner = new Scanner(true, true, false, 0x2F0000L, 0x310000L, null, null, true, false);
                break;
            }
            case 4: {
                this.apiLevel = level;
                this.scanner = new Scanner(true, true, false, 0x330000L, 0x330000L, null, null, true, false);
                break;
            }
            case 8: {
                this.apiLevel = level;
                this.scanner = new Scanner(true, true, false, 0x340000L, 0x340000L, null, null, true, false);
                break;
            }
            case 9: {
                this.apiLevel = level;
                this.scanner = new Scanner(true, true, false, 0x350000L, 0x350000L, null, null, true, false);
                break;
            }
            case 10: {
                this.apiLevel = level;
                this.scanner = new Scanner(true, true, false, 0x360000L, 0x360000L, null, null, true, false);
                break;
            }
            case 11: {
                this.apiLevel = level;
                long compliance = ClassFileConstants.getComplianceLevelForJavaVersion(55);
                this.scanner = new Scanner(true, true, false, compliance, compliance, null, null, true, false);
                break;
            }
            case 12: {
                this.apiLevel = level;
                long compliance = ClassFileConstants.getComplianceLevelForJavaVersion(56);
                this.scanner = new Scanner(true, true, false, compliance, compliance, null, null, true, previewEnabled);
                break;
            }
            case 13: {
                this.apiLevel = level;
                long compliance = ClassFileConstants.getComplianceLevelForJavaVersion(57);
                this.scanner = new Scanner(true, true, false, compliance, compliance, null, null, true, previewEnabled);
                break;
            }
            case 14: {
                this.apiLevel = level;
                long compliance = ClassFileConstants.getComplianceLevelForJavaVersion(58);
                this.scanner = new Scanner(true, true, false, compliance, compliance, null, null, true, previewEnabled);
                break;
            }
            case 15: {
                this.apiLevel = level;
                long compliance = ClassFileConstants.getComplianceLevelForJavaVersion(59);
                this.scanner = new Scanner(true, true, false, compliance, compliance, null, null, true, previewEnabled);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported JLS level");
            }
        }
    }

    public AST(Map options) {
        this(apiLevelMap.get(options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.source")), "enabled".equals(options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.problem.enablePreviewFeatures")));
        long complianceLevel;
        long sourceLevel;
        switch (this.apiLevel) {
            case 2: 
            case 3: {
                sourceLevel = 0x2F0000L;
                complianceLevel = 0x310000L;
                break;
            }
            case 4: {
                sourceLevel = 0x330000L;
                complianceLevel = 0x330000L;
                break;
            }
            default: {
                complianceLevel = sourceLevel = jdkLevelMap.get(options.get("io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.source")).longValue();
            }
        }
        this.scanner = new Scanner(true, true, false, sourceLevel, complianceLevel, null, null, true, this.previewEnabled);
    }

    private static Map<String, Long> getLevelMapTable() {
        HashMap<String, Long> t = new HashMap<String, Long>();
        t.put(null, 0x2E0000L);
        t.put("1.2", 0x2E0000L);
        t.put("1.3", 0x2F0000L);
        t.put("1.4", 0x300000L);
        t.put("1.5", 0x310000L);
        t.put("1.6", 0x320000L);
        t.put("1.7", 0x330000L);
        t.put("1.8", 0x340000L);
        t.put("9", 0x350000L);
        t.put("10", 0x360000L);
        t.put("11", 0x370000L);
        t.put("12", 0x380000L);
        t.put("13", 0x390000L);
        t.put("14", 0x3A0000L);
        t.put("15", 0x3B0000L);
        return Collections.unmodifiableMap(t);
    }

    private static Map<String, Integer> getApiLevelMapTable() {
        HashMap<String, Integer> t = new HashMap<String, Integer>();
        t.put(null, 2);
        t.put("1.2", 2);
        t.put("1.3", 3);
        t.put("1.4", 4);
        t.put("1.5", 4);
        t.put("1.6", 4);
        t.put("1.7", 4);
        t.put("1.8", 8);
        t.put("9", 9);
        t.put("10", 10);
        t.put("11", 11);
        t.put("12", 12);
        t.put("13", 13);
        t.put("14", 14);
        t.put("15", 15);
        return Collections.unmodifiableMap(t);
    }

    public int apiLevel() {
        return this.apiLevel;
    }

    public ASTNode createInstance(Class nodeClass) {
        if (nodeClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Constructor c = nodeClass.getDeclaredConstructor(AST_CLASS);
            Object result = c.newInstance(this.THIS_AST);
            return (ASTNode)result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getCause());
        }
    }

    public ASTNode createInstance(int nodeType) {
        Class nodeClass = ASTNode.nodeClassForType(nodeType);
        return this.createInstance(nodeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableEvents() {
        Object object = this.internalASTLock;
        synchronized (object) {
            ++this.disableEvents;
        }
    }

    BindingResolver getBindingResolver() {
        return this.resolver;
    }

    int getDefaultNodeFlag() {
        return this.defaultNodeFlag;
    }

    Name internalNewName(String[] identifiers) {
        int count = identifiers.length;
        if (count == 0) {
            throw new IllegalArgumentException();
        }
        SimpleName simpleName = new SimpleName(this);
        simpleName.internalSetIdentifier(identifiers[0]);
        Name result = simpleName;
        int i = 1;
        while (i < count) {
            SimpleName name = new SimpleName(this);
            name.internalSetIdentifier(identifiers[i]);
            result = this.newQualifiedName(result, name);
            ++i;
        }
        return result;
    }

    public long modificationCount() {
        return this.modificationCount;
    }

    void modifying() {
        if (this.disableEvents > 0) {
            return;
        }
        ++this.modificationCount;
    }

    private void setArrayComponentType(ArrayType arrayType, Type type) {
        arrayType.setComponentType(type);
    }

    public AnnotationTypeDeclaration newAnnotationTypeDeclaration() {
        AnnotationTypeDeclaration result = new AnnotationTypeDeclaration(this);
        return result;
    }

    public ArrayType newArrayType(Type elementType) {
        if (this.apiLevel < 8) {
            ArrayType result = new ArrayType(this);
            this.setArrayComponentType(result, elementType);
            return result;
        }
        if (elementType.isArrayType()) {
            throw new IllegalArgumentException();
        }
        ArrayType result = new ArrayType(this);
        result.setElementType(elementType);
        return result;
    }

    public ArrayType newArrayType(Type elementType, int dimensions) {
        if (elementType == null) {
            throw new IllegalArgumentException();
        }
        if (dimensions < 0 || dimensions > 255) {
            throw new IllegalArgumentException();
        }
        if (this.apiLevel < 8) {
            if (dimensions < 1) {
                throw new IllegalArgumentException();
            }
            ArrayType result = new ArrayType(this);
            this.setArrayComponentType(result, elementType);
            int i = 2;
            while (i <= dimensions) {
                result = this.newArrayType(result);
                ++i;
            }
            return result;
        }
        if (elementType.isArrayType()) {
            throw new IllegalArgumentException();
        }
        ArrayType result = new ArrayType(this, 0);
        result.setElementType(elementType);
        int i = 0;
        while (i < dimensions) {
            result.dimensions().add(new Dimension(this));
            ++i;
        }
        return result;
    }

    public Block newBlock() {
        return new Block(this);
    }

    public CompilationUnit newCompilationUnit() {
        return new CompilationUnit(this);
    }

    public ExpressionStatement newExpressionStatement(Expression expression) {
        ExpressionStatement result = new ExpressionStatement(this);
        result.setExpression(expression);
        return result;
    }

    public Dimension newDimension() {
        Dimension result = new Dimension(this);
        return result;
    }

    public ImportDeclaration newImportDeclaration() {
        ImportDeclaration result = new ImportDeclaration(this);
        return result;
    }

    public Initializer newInitializer() {
        Initializer result = new Initializer(this);
        return result;
    }

    public MemberRef newMemberRef() {
        MemberRef result = new MemberRef(this);
        return result;
    }

    public MethodRef newMethodRef() {
        MethodRef result = new MethodRef(this);
        return result;
    }

    public MethodRefParameter newMethodRefParameter() {
        MethodRefParameter result = new MethodRefParameter(this);
        return result;
    }

    public ModuleDeclaration newModuleDeclaration() {
        ModuleDeclaration result = new ModuleDeclaration(this);
        return result;
    }

    public Name newName(String qualifiedName) {
        StringTokenizer t = new StringTokenizer(qualifiedName, ".", true);
        Name result = null;
        int balance = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.indexOf(46) >= 0) {
                if (s.length() > 1) {
                    throw new IllegalArgumentException();
                }
                if (--balance >= 0) continue;
                throw new IllegalArgumentException();
            }
            ++balance;
            SimpleName name = this.newSimpleName(s);
            result = result == null ? name : this.newQualifiedName(result, name);
        }
        if (balance != 1) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public Name newName(String[] identifiers) {
        int count = identifiers.length;
        if (count == 0) {
            throw new IllegalArgumentException();
        }
        Name result = this.newSimpleName(identifiers[0]);
        int i = 1;
        while (i < count) {
            SimpleName name = this.newSimpleName(identifiers[i]);
            result = this.newQualifiedName(result, name);
            ++i;
        }
        return result;
    }

    public PackageDeclaration newPackageDeclaration() {
        PackageDeclaration result = new PackageDeclaration(this);
        return result;
    }

    public PrimitiveType newPrimitiveType(PrimitiveType.Code typeCode) {
        PrimitiveType result = new PrimitiveType(this);
        result.setPrimitiveTypeCode(typeCode);
        return result;
    }

    public QualifiedName newQualifiedName(Name qualifier, SimpleName name) {
        QualifiedName result = new QualifiedName(this);
        result.setQualifier(qualifier);
        result.setName(name);
        return result;
    }

    public SimpleName newSimpleName(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        SimpleName result = new SimpleName(this);
        result.setIdentifier(identifier);
        return result;
    }

    public SimpleType newSimpleType(Name typeName) {
        SimpleType result = new SimpleType(this);
        result.setName(typeName);
        return result;
    }

    public SingleVariableDeclaration newSingleVariableDeclaration() {
        SingleVariableDeclaration result = new SingleVariableDeclaration(this);
        return result;
    }

    public TagElement newTagElement() {
        TagElement result = new TagElement(this);
        return result;
    }

    public TextElement newTextElement() {
        TextElement result = new TextElement(this);
        return result;
    }

    public TypeDeclaration newTypeDeclaration() {
        TypeDeclaration result = new TypeDeclaration(this);
        result.setInterface(false);
        return result;
    }

    public VariableDeclarationFragment newVariableDeclarationFragment() {
        VariableDeclarationFragment result = new VariableDeclarationFragment(this);
        return result;
    }

    public WildcardType newWildcardType() {
        WildcardType result = new WildcardType(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postAddChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postAddChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postCloneNodeEvent(ASTNode node, ASTNode clone) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postCloneNodeEvent(node, clone);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRemoveChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postRemoveChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postReplaceChildEvent(ASTNode node, ASTNode child, ASTNode newChild, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postReplaceChildEvent(node, child, newChild, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postValueChangeEvent(ASTNode node, SimplePropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postValueChangeEvent(node, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preAddChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preAddChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preCloneNodeEvent(ASTNode node) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preCloneNodeEvent(node);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preRemoveChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preRemoveChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preReplaceChildEvent(ASTNode node, ASTNode child, ASTNode newChild, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preReplaceChildEvent(node, child, newChild, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preValueChangeEvent(ASTNode node, SimplePropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preValueChangeEvent(node, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reenableEvents() {
        Object object = this.internalASTLock;
        synchronized (object) {
            --this.disableEvents;
        }
    }

    void setBindingResolver(BindingResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolver = resolver;
    }

    void setDefaultNodeFlag(int flag) {
        this.defaultNodeFlag = flag;
    }

    void setFlag(int newValue) {
        this.bits |= newValue;
    }

    void setOriginalModificationCount(long count) {
        this.originalModificationCount = count;
    }

    public boolean isPreviewEnabledSet() {
        return this.previewEnabled;
    }

    public boolean isPreviewEnabled() {
        return this.apiLevel == 15 && this.previewEnabled;
    }
}

