/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.flow;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.codegen.BranchLabel;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.flow.FlowContext;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.flow.SwitchFlowContext;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BlockScope;

public class LabelFlowContext
extends SwitchFlowContext {
    public char[] labelName;

    public LabelFlowContext(FlowContext parent, ASTNode associatedNode, char[] labelName, BranchLabel breakLabel, BlockScope scope) {
        super(parent, associatedNode, breakLabel, false, true);
        this.labelName = labelName;
        this.checkLabelValidity(scope);
    }

    void checkLabelValidity(BlockScope scope) {
        FlowContext current = this.getLocalParent();
        while (current != null) {
            char[] currentLabelName = current.labelName();
            if (currentLabelName != null && CharOperation.equals(currentLabelName, this.labelName)) {
                scope.problemReporter().alreadyDefinedLabel(this.labelName, this.associatedNode);
            }
            current = current.getLocalParent();
        }
    }

    @Override
    public String individualToString() {
        return "Label flow context [label:" + String.valueOf(this.labelName) + "]";
    }

    @Override
    public char[] labelName() {
        return this.labelName;
    }
}

