/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.Flags;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IMemberValuePair;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.Signature;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryAnnotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryElementValuePair;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryField;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryNestedType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IRecordComponent;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeConstants;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.SuffixConstants;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.Annotation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.AnnotationInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryField;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryMember;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryMethod;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.BinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.LocalVariable;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.OpenableElementInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.TypeParameter;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.TypeParameterElementInfo;
import java.util.ArrayList;
import java.util.HashMap;

class ClassFileInfo
extends OpenableElementInfo
implements SuffixConstants {
    protected JavaElement[] binaryChildren = null;
    protected ITypeParameter[] typeParameters;

    ClassFileInfo() {
    }

    private void generateAnnotationsInfos(JavaElement member, IBinaryAnnotation[] binaryAnnotations, long tagBits, HashMap newElements) {
        this.generateAnnotationsInfos(member, null, binaryAnnotations, tagBits, newElements);
    }

    private void generateAnnotationsInfos(JavaElement member, char[] parameterName, IBinaryAnnotation[] binaryAnnotations, long tagBits, HashMap newElements) {
        if (binaryAnnotations != null) {
            int i = 0;
            int length = binaryAnnotations.length;
            while (i < length) {
                IBinaryAnnotation annotationInfo = binaryAnnotations[i];
                this.generateAnnotationInfo(member, parameterName, newElements, annotationInfo, null);
                ++i;
            }
        }
        this.generateStandardAnnotationsInfos(member, parameterName, tagBits, newElements);
    }

    private void generateAnnotationInfo(JavaElement parent, HashMap newElements, IBinaryAnnotation annotationInfo, String memberValuePairName) {
        this.generateAnnotationInfo(parent, null, newElements, annotationInfo, memberValuePairName);
    }

    private void generateAnnotationInfo(JavaElement parent, char[] parameterName, HashMap newElements, IBinaryAnnotation annotationInfo, String memberValuePairName) {
        char[] typeName = Signature.toCharArray(CharOperation.replaceOnCopy(annotationInfo.getTypeName(), '/', '.'));
        Annotation annotation = new Annotation(parent, new String(typeName), memberValuePairName);
        while (newElements.containsKey(annotation)) {
            annotation.occurrenceCount = annotation.occurrenceCount + 1;
        }
        newElements.put(annotation, annotationInfo);
        IBinaryElementValuePair[] pairs = annotationInfo.getElementValuePairs();
        int i = 0;
        int length = pairs.length;
        while (i < length) {
            Object value = pairs[i].getValue();
            if (value instanceof IBinaryAnnotation) {
                this.generateAnnotationInfo(annotation, newElements, (IBinaryAnnotation)value, new String(pairs[i].getName()));
            } else if (value instanceof Object[]) {
                Object[] valueArray = (Object[])value;
                int j = 0;
                int valueArrayLength = valueArray.length;
                while (j < valueArrayLength) {
                    Object nestedValue = valueArray[j];
                    if (nestedValue instanceof IBinaryAnnotation) {
                        this.generateAnnotationInfo(annotation, newElements, (IBinaryAnnotation)nestedValue, new String(pairs[i].getName()));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void generateStandardAnnotationsInfos(JavaElement javaElement, char[] parameterName, long tagBits, HashMap newElements) {
        if ((tagBits & 0x77FFFFF840000000L) == 0L) {
            return;
        }
        if ((tagBits & 0x20600FF840000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_TARGET, this.getTargetElementTypes(tagBits), newElements);
        }
        if ((tagBits & 0x300000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_RETENTION, this.getRetentionPolicy(tagBits), newElements);
        }
        if ((tagBits & 0x400000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_DEPRECATED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x800000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x1000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_ANNOTATION_INHERITED, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x10000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
        if ((tagBits & 0x8000000000000L) != 0L) {
            this.generateStandardAnnotation(javaElement, TypeConstants.JAVA_LANG_SAFEVARARGS, Annotation.NO_MEMBER_VALUE_PAIRS, newElements);
        }
    }

    private void generateStandardAnnotation(JavaElement javaElement, char[][] typeName, IMemberValuePair[] members, HashMap newElements) {
        Annotation annotation = new Annotation(javaElement, new String(CharOperation.concatWith(typeName, '.')));
        AnnotationInfo annotationInfo = new AnnotationInfo();
        annotationInfo.members = members;
        newElements.put(annotation, annotationInfo);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IMemberValuePair[] getTargetElementTypes(long tagBits) {
        void var5_7;
        ArrayList<String> values = new ArrayList<String>();
        String elementType = String.valueOf(new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE, '.'))) + '.';
        if ((tagBits & 0x1000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.TYPE));
        }
        if ((tagBits & 0x2000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_FIELD));
        }
        if ((tagBits & 0x4000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_METHOD));
        }
        if ((tagBits & 0x8000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_PARAMETER));
        }
        if ((tagBits & 0x10000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_CONSTRUCTOR));
        }
        if ((tagBits & 0x20000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_LOCAL_VARIABLE));
        }
        if ((tagBits & 0x40000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_ANNOTATION_TYPE));
        }
        if ((tagBits & 0x80000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_PACKAGE));
        }
        if ((tagBits & 0x20000000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.TYPE_USE_TARGET));
        }
        if ((tagBits & 0x40000000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.TYPE_PARAMETER_TARGET));
        }
        if ((tagBits & 0x2000000000000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_MODULE));
        }
        if ((tagBits & 0x40000000L) != 0L) {
            values.add(String.valueOf(elementType) + new String(TypeConstants.UPPER_RECORD_COMPONENT));
        }
        if (values.size() == 0) {
            if ((tagBits & 0x800000000L) == 0L) return Annotation.NO_MEMBER_VALUE_PAIRS;
            String[] stringArray = CharOperation.NO_STRINGS;
            return new IMemberValuePair[]{new IMemberValuePair(){}};
        } else if (values.size() == 1) {
            Object e = values.get(0);
            return new IMemberValuePair[]{new /* invalid duplicate definition of identical inner class */};
        } else {
            String[] stringArray = values.toArray(new String[values.size()]);
        }
        return new IMemberValuePair[]{new /* invalid duplicate definition of identical inner class */};
    }

    private IMemberValuePair[] getRetentionPolicy(long tagBits) {
        if ((tagBits & 0x300000000000L) == 0L) {
            return Annotation.NO_MEMBER_VALUE_PAIRS;
        }
        String retention = null;
        retention = (tagBits & 0x300000000000L) == 0x300000000000L ? String.valueOf(new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, '.'))) + '.' + new String(TypeConstants.UPPER_RUNTIME) : ((tagBits & 0x100000000000L) != 0L ? String.valueOf(new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, '.'))) + '.' + new String(TypeConstants.UPPER_SOURCE) : String.valueOf(new String(CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, '.'))) + '.' + new String(TypeConstants.UPPER_CLASS));
        final String value = retention;
        return new IMemberValuePair[]{new IMemberValuePair(){}};
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        int fieldCount = fields.length;
        while (i < fieldCount) {
            IBinaryField fieldInfo = fields[i];
            if (!typeInfo.isRecord() || (fieldInfo.getModifiers() & 8) != 0) {
                BinaryField field = new BinaryField((JavaElement)((Object)type), manager.intern(new String(fieldInfo.getName())));
                newElements.put(field, fieldInfo);
                childrenHandles.add(field);
                this.generateAnnotationsInfos(field, fieldInfo.getAnnotations(), fieldInfo.getTagBits(), newElements);
            }
            ++i;
        }
    }

    private void generateRecordComponentInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles) {
        IRecordComponent[] components = typeInfo.getRecordComponents();
        if (components == null) {
            return;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        int fieldCount = components.length;
        while (i < fieldCount) {
            IRecordComponent componentInfo = components[i];
            BinaryField component = new BinaryField((JavaElement)((Object)type), manager.intern(new String(componentInfo.getName()))){

                @Override
                public boolean isRecordComponent() throws JavaModelException {
                    return true;
                }
            };
            newElements.put(component, componentInfo);
            childrenHandles.add(component);
            this.generateAnnotationsInfos(component, componentInfo.getAnnotations(), componentInfo.getTagBits(), newElements);
            ++i;
        }
    }

    private void generateInnerClassHandles(IType type, IBinaryType typeInfo, ArrayList childrenHandles) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            IPackageFragment pkg = (IPackageFragment)type.getAncestor(4);
            int i = 0;
            int typeCount = innerTypes.length;
            while (i < typeCount) {
                IBinaryNestedType binaryType = innerTypes[i];
                IClassFile parentClassFile = pkg.getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(binaryType.getName()))) + ".class");
                BinaryType innerType = new BinaryType((JavaElement)((Object)parentClassFile), ClassFile.simpleName(binaryType.getName()));
                childrenHandles.add(innerType);
                ++i;
            }
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList childrenHandles, ArrayList typeParameterHandles) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        int methodCount = methods.length;
        while (i < methodCount) {
            IBinaryMethod methodInfo = methods[i];
            boolean isConstructor = methodInfo.isConstructor();
            boolean isEnum = false;
            try {
                isEnum = type.isEnum();
            }
            catch (JavaModelException javaModelException) {}
            boolean useGenericSignature = true;
            char[] signature = methodInfo.getGenericSignature();
            String[] pNames = null;
            if (signature == null) {
                int length;
                useGenericSignature = false;
                signature = methodInfo.getMethodDescriptor();
                if (isEnum && isConstructor && (length = (pNames = Signature.getParameterTypes(new String(signature))).length - 2) >= 0) {
                    String[] stringArray = pNames;
                    pNames = new String[length];
                    System.arraycopy(stringArray, 2, pNames, 0, length);
                }
            }
            String selector = new String(methodInfo.getSelector());
            if (isConstructor) {
                selector = type.getElementName();
            }
            try {
                if (!isEnum || !isConstructor || useGenericSignature) {
                    pNames = Signature.getParameterTypes(new String(signature));
                }
                if (isConstructor && useGenericSignature && type.isMember() && !Flags.isStatic(type.getFlags())) {
                    int length = pNames.length;
                    String[] stringArray = pNames;
                    pNames = new String[length + 1];
                    System.arraycopy(stringArray, 0, pNames, 1, length);
                    char[] descriptor = methodInfo.getMethodDescriptor();
                    String[] parameterTypes = Signature.getParameterTypes(new String(descriptor));
                    pNames[0] = parameterTypes[0];
                }
            }
            catch (JavaModelException | IllegalArgumentException object) {
                signature = methodInfo.getMethodDescriptor();
                pNames = Signature.getParameterTypes(new String(signature));
            }
            char[][] paramNames = new char[pNames.length][];
            int j = 0;
            while (j < pNames.length) {
                paramNames[j] = pNames[j].toCharArray();
                ++j;
            }
            char[][] parameterTypes = ClassFile.translatedNames(paramNames);
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            selector = manager.intern(selector);
            int j2 = 0;
            while (j2 < pNames.length) {
                pNames[j2] = manager.intern(new String(parameterTypes[j2]));
                ++j2;
            }
            BinaryMethod method = new BinaryMethod((JavaElement)((Object)type), selector, pNames);
            childrenHandles.add(method);
            while (newElements.containsKey(method)) {
                method.occurrenceCount = method.occurrenceCount + 1;
            }
            newElements.put(method, methodInfo);
            int max = pNames.length;
            Object argumentNames = methodInfo.getArgumentNames();
            if (argumentNames == null || ((char[][])argumentNames).length < max) {
                argumentNames = new char[max][];
                int j3 = 0;
                while (j3 < max) {
                    argumentNames[j3] = ("arg" + j3).toCharArray();
                    ++j3;
                }
            }
            int startIndex = 0;
            try {
                if (isConstructor) {
                    if (isEnum) {
                        startIndex = 2;
                    } else if (type.isMember() && !Flags.isStatic(type.getFlags())) {
                        startIndex = 1;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            int j4 = startIndex;
            while (j4 < max) {
                IBinaryAnnotation[] parameterAnnotations = methodInfo.getParameterAnnotations(j4 - startIndex, typeInfo.getFileName());
                if (parameterAnnotations != null) {
                    LocalVariable localVariable = new LocalVariable(method, new String(argumentNames[j4]), 0, -1, 0, -1, method.parameterTypes[j4], null, -1, true);
                    this.generateAnnotationsInfos(localVariable, argumentNames[j4], parameterAnnotations, methodInfo.getTagBits(), newElements);
                }
                ++j4;
            }
            this.generateTypeParameterInfos(method, signature, newElements, typeParameterHandles);
            this.generateAnnotationsInfos(method, methodInfo.getAnnotations(), methodInfo.getTagBits(), newElements);
            Object defaultValue = methodInfo.getDefaultValue();
            if (defaultValue instanceof IBinaryAnnotation) {
                this.generateAnnotationInfo(method, newElements, (IBinaryAnnotation)defaultValue, new String(methodInfo.getSelector()));
            }
            ++i;
        }
    }

    private void generateTypeParameterInfos(BinaryMember parent, char[] signature, HashMap newElements, ArrayList typeParameterHandles) {
        if (signature == null) {
            return;
        }
        char[][] typeParameterSignatures = Signature.getTypeParameters(signature);
        int i = 0;
        int typeParameterCount = typeParameterSignatures.length;
        while (i < typeParameterCount) {
            char[] typeParameterSignature = typeParameterSignatures[i];
            char[] typeParameterName = Signature.getTypeVariable(typeParameterSignature);
            CharOperation.replace(typeParameterSignature, '/', '.');
            char[][] typeParameterBoundSignatures = Signature.getTypeParameterBounds(typeParameterSignature);
            int boundLength = typeParameterBoundSignatures.length;
            char[][] typeParameterBounds = new char[boundLength][];
            int j = 0;
            while (j < boundLength) {
                typeParameterBounds[j] = Signature.toCharArray(typeParameterBoundSignatures[j]);
                ++j;
            }
            TypeParameter typeParameter = new TypeParameter(parent, new String(typeParameterName));
            TypeParameterElementInfo info = new TypeParameterElementInfo();
            info.bounds = typeParameterBounds;
            info.boundsSignatures = typeParameterBoundSignatures;
            typeParameterHandles.add(typeParameter);
            while (newElements.containsKey(typeParameter)) {
                typeParameter.occurrenceCount = typeParameter.occurrenceCount + 1;
            }
            newElements.put(typeParameter, info);
            ++i;
        }
    }

    protected void readBinaryChildren(ClassFile classFile, HashMap newElements, IBinaryType typeInfo) {
        ArrayList childrenHandles = new ArrayList();
        BinaryType type = (BinaryType)classFile.getType();
        ArrayList typeParameterHandles = new ArrayList();
        if (typeInfo != null) {
            this.generateAnnotationsInfos(type, typeInfo.getAnnotations(), typeInfo.getTagBits(), newElements);
            this.generateTypeParameterInfos(type, typeInfo.getGenericSignature(), newElements, typeParameterHandles);
            this.generateFieldInfos(type, typeInfo, newElements, childrenHandles);
            this.generateRecordComponentInfos(type, typeInfo, newElements, childrenHandles);
            this.generateMethodInfos(type, typeInfo, newElements, childrenHandles, typeParameterHandles);
            this.generateInnerClassHandles(type, typeInfo, childrenHandles);
        }
        this.binaryChildren = new JavaElement[childrenHandles.size()];
        childrenHandles.toArray(this.binaryChildren);
        int typeParameterHandleSize = typeParameterHandles.size();
        if (typeParameterHandleSize == 0) {
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        } else {
            this.typeParameters = new ITypeParameter[typeParameterHandleSize];
            typeParameterHandles.toArray(this.typeParameters);
        }
    }

    void removeBinaryChildren() throws JavaModelException {
        int i;
        JavaModelManager manager;
        if (this.binaryChildren != null) {
            manager = JavaModelManager.getJavaModelManager();
            i = 0;
            while (i < this.binaryChildren.length) {
                JavaElement child = this.binaryChildren[i];
                if (child instanceof BinaryType) {
                    manager.removeInfoAndChildren((JavaElement)child.getParent());
                } else {
                    manager.removeInfoAndChildren(child);
                }
                ++i;
            }
            this.binaryChildren = JavaElement.NO_ELEMENTS;
        }
        if (this.typeParameters != null) {
            manager = JavaModelManager.getJavaModelManager();
            i = 0;
            while (i < this.typeParameters.length) {
                TypeParameter typeParameter = (TypeParameter)this.typeParameters[i];
                manager.removeInfoAndChildren(typeParameter);
                ++i;
            }
            this.typeParameters = TypeParameter.NO_TYPE_PARAMETERS;
        }
    }
}

