/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IField;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.FieldDeclaration;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.VariableDeclarationFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.rewrite.ASTRewrite;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CreateTypeMemberOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Messages;
import java.util.Iterator;

public class CreateFieldOperation
extends CreateTypeMemberOperation {
    public CreateFieldOperation(IType parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, cu);
        if (node.getNodeType() != 23) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        return this.getType().getField(this.getASTNodeName());
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createFieldProgress;
    }

    private VariableDeclarationFragment getFragment(ASTNode node) {
        Iterator fragments = ((FieldDeclaration)node).fragments().iterator();
        if (this.anchorElement != null) {
            VariableDeclarationFragment fragment = null;
            String fragmentName = this.anchorElement.getElementName();
            while (fragments.hasNext()) {
                fragment = (VariableDeclarationFragment)fragments.next();
                if (!fragment.getName().getIdentifier().equals(fragmentName)) continue;
                return fragment;
            }
            return fragment;
        }
        return (VariableDeclarationFragment)fragments.next();
    }

    @Override
    protected void initializeDefaultPosition() {
        IType parentElement = this.getType();
        try {
            IField[] fields = parentElement.getFields();
            if (fields != null && fields.length > 0) {
                IField lastField = fields[fields.length - 1];
                if (parentElement.isEnum()) {
                    IField field = lastField;
                    if (!field.isEnumConstant()) {
                        this.createAfter(lastField);
                    }
                } else {
                    this.createAfter(lastField);
                }
            } else {
                IJavaElement[] elements = parentElement.getChildren();
                if (elements != null && elements.length > 0) {
                    this.createBefore(elements[0]);
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    protected IJavaModelStatus verifyNameCollision() {
        String fieldName;
        IType type;
        if (this.createdNode != null && (type = this.getType()).getField(fieldName = this.getASTNodeName()).exists()) {
            return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, fieldName));
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    private String getASTNodeName() {
        if (this.alteredName != null) {
            return this.alteredName;
        }
        return this.getFragment(this.createdNode).getName().getIdentifier();
    }

    @Override
    protected SimpleName rename(ASTNode node, SimpleName newName) {
        VariableDeclarationFragment fragment = this.getFragment(node);
        SimpleName oldName = fragment.getName();
        fragment.setName(newName);
        return oldName;
    }
}

