/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimpleName;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.rewrite.ASTRewrite;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.CreateTypeMemberOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Messages;

public class CreateInitializerOperation
extends CreateTypeMemberOperation {
    protected int numberOfInitializers = 1;

    public CreateInitializerOperation(IType parentElement, String source) {
        super(parentElement, source, false);
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, cu);
        if (node.getNodeType() != 28) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        try {
            this.getType().getCompilationUnit().close();
            if (this.anchorElement == null) {
                return this.getType().getInitializer(this.numberOfInitializers);
            }
            IJavaElement[] children = this.getType().getChildren();
            int count = 0;
            int i = 0;
            while (i < children.length) {
                IJavaElement child = children[i];
                if (child.equals(this.anchorElement)) {
                    if (child.getElementType() == 10 && this.insertionPolicy == 2) {
                        ++count;
                    }
                    return this.getType().getInitializer(count);
                }
                if (child.getElementType() == 10) {
                    ++count;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createInitializerProgress;
    }

    @Override
    protected SimpleName rename(ASTNode node, SimpleName newName) {
        return null;
    }

    @Override
    protected void initializeDefaultPosition() {
        IType parentElement = this.getType();
        try {
            IJavaElement[] elements = parentElement.getInitializers();
            if (elements != null && elements.length > 0) {
                this.numberOfInitializers = elements.length;
                this.createAfter(elements[elements.length - 1]);
            } else {
                elements = parentElement.getChildren();
                if (elements != null && elements.length > 0) {
                    this.createBefore(elements[0]);
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

