/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IModuleDescription;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModulePathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragmentRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectEntry
implements IModulePathEntry {
    JavaProject project;

    static boolean representsProject(IModulePathEntry entry, IJavaProject otherProject) {
        if (entry instanceof ProjectEntry) {
            return ((ProjectEntry)entry).project.equals(otherProject);
        }
        return false;
    }

    public ProjectEntry(JavaProject project) {
        this.project = project;
    }

    @Override
    public IModule getModule() {
        try {
            IModuleDescription module = this.project.getModuleDescription();
            if (module != null) {
                return (IModule)((JavaElement)((Object)module)).getElementInfo();
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    @Override
    public boolean isAutomaticModule() {
        return false;
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        IModule mod = this.getModule();
        if (mod == null ? moduleName != null : !String.valueOf(mod.name()).equals(moduleName)) {
            return null;
        }
        try {
            IJavaElement element = this.project.findElement((IPath)new Path(qualifiedPackageName.replace('.', '/')));
            if (element instanceof IPackageFragment) {
                Object object;
                if (mod != null) {
                    char[][] cArrayArray = new char[1][];
                    object = cArrayArray;
                    cArrayArray[0] = mod.name();
                } else {
                    object = CharOperation.NO_CHAR_CHAR;
                }
                return object;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root instanceof PackageFragmentRoot && ((PackageFragmentRoot)root).hasCompilationUnit(qualifiedPackageName, moduleName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }
}

