/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ISourceReference;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.MoveElementsOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Messages;

public class RenameElementsOperation
extends MoveElementsOperation {
    public RenameElementsOperation(IJavaElement[] elements, IJavaElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_renameElementProgress;
    }

    @Override
    protected boolean isRename() {
        return true;
    }

    @Override
    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList == null || this.renamingsList.length == 0) {
            return new JavaModelStatus(982);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(IJavaElement element) throws JavaModelException {
        int elementType;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        if (!(element instanceof ISourceReference)) {
            this.error(967, element);
        }
        if ((elementType = element.getElementType()) < 7 || elementType == 10) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

