/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.IDestructable;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.INdStruct;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.ITypeFactory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.NdStruct;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.Database;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.IndexException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.FieldShort;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.StructDef;

public abstract class NdNode
extends NdStruct
implements IDestructable {
    public static final FieldShort NODE_TYPE;
    public static final StructDef<NdNode> type;

    static {
        type = StructDef.create(NdNode.class, NdStruct.type);
        NODE_TYPE = type.addShort();
        type.done();
    }

    public static NdNode load(Nd nd, long address) {
        if (address == 0L) {
            return null;
        }
        try {
            return nd.getNode(address, NODE_TYPE.get(nd, address));
        }
        catch (IndexException e) {
            nd.describeProblem().addProblemAddress(NODE_TYPE, address).attachTo(e);
            throw e;
        }
    }

    public static <T extends INdStruct> T load(Nd nd, long address, StructDef<T> typeToLoad) {
        NdNode result;
        if (address == 0L) {
            return null;
        }
        try {
            result = nd.getNode(address, NODE_TYPE.get(nd, address));
        }
        catch (IndexException e) {
            nd.describeProblem().addProblemAddress(NODE_TYPE, address).attachTo(e);
            throw e;
        }
        Class<T> clazz = typeToLoad.getStructClass();
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw nd.describeProblem().addProblemAddress(NODE_TYPE, address).build("Found wrong data type at address " + address + ". Expected a subclass of " + clazz + " but found " + result.getClass());
        }
        return (T)result;
    }

    public final void delete() {
        this.getNd().delete(this.address);
    }

    protected NdNode(Nd nd) {
        super(nd, 0L);
        Database db = nd.getDB();
        short nodeType = nd.getNodeType(this.getClass());
        ITypeFactory factory1 = nd.getTypeFactory(nodeType);
        this.address = db.malloc(factory1.getRecordSize(), (short)(256 + nodeType));
        NODE_TYPE.put(nd, this.address, nodeType);
    }

    @Override
    public final long getAddress() {
        return this.address;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NdNode) {
            NdNode other = (NdNode)obj;
            return this.getNd() == other.getNd() && this.address == other.address;
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        return (int)(this.address >> 3);
    }

    @Override
    public void destruct() {
    }
}

