/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.ITypeFactory;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.BaseField;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.IDestructableField;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.StructDef;

public final class Field<T>
extends BaseField
implements IDestructableField {
    public final ITypeFactory<T> factory;

    public Field(ITypeFactory<T> objectFactory, String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.factory = objectFactory;
    }

    public T get(Nd nd, long address) {
        return this.factory.create(nd, address + (long)this.offset);
    }

    @Override
    public void destruct(Nd nd, long address) {
        this.factory.destruct(nd, address + (long)this.offset);
    }

    @Override
    public int getRecordSize() {
        return this.factory.getRecordSize();
    }

    @Override
    public int getAlignment() {
        return 8;
    }

    public static <T> Field<T> create(StructDef<?> struct, StructDef<T> fieldType) {
        Field<T> result = new Field<T>(fieldType.getFactory(), struct.getStructName(), struct.getNumFields());
        struct.add(result);
        struct.addDestructableField(result);
        fieldType.addDependency(struct);
        return result;
    }
}

