/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search;

import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.SearchDocument;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.SearchParticipant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.BasicSearchEngine;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.search.processing.JobManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JavaSearchDocument
extends SearchDocument {
    private IFile file;
    protected byte[] byteContents;
    protected char[] charContents;

    public JavaSearchDocument(String documentPath, SearchParticipant participant) {
        super(documentPath, participant);
    }

    public JavaSearchDocument(ZipEntry zipEntry, IPath zipFilePath, byte[] contents, SearchParticipant participant) {
        this(zipFilePath + "|" + zipEntry.getName(), contents, participant);
    }

    public JavaSearchDocument(String documentPath, byte[] contents, SearchParticipant participant) {
        super(documentPath, participant);
        this.byteContents = contents;
    }

    @Override
    public byte[] getByteContents() {
        if (this.byteContents != null) {
            return this.byteContents;
        }
        try {
            return Util.getResourceContentsAsByteArray(this.getFile());
        }
        catch (JavaModelException e) {
            if (BasicSearchEngine.VERBOSE || JobManager.VERBOSE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public char[] getCharContents() {
        if (this.charContents != null) {
            return this.charContents;
        }
        try {
            return Util.getResourceContentsAsCharArray(this.getFile());
        }
        catch (JavaModelException e) {
            if (BasicSearchEngine.VERBOSE || JobManager.VERBOSE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private IFile getFile() {
        if (this.file == null) {
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getPath()));
        }
        return this.file;
    }

    public String toString() {
        return "SearchDocument for " + this.getPath();
    }
}

