/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaElement;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IRegion;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IType;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeHierarchy;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.search.IJavaSearchScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.hierarchy.RegionBasedTypeHierarchy;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.hierarchy.TypeHierarchy;

public class CreateTypeHierarchyOperation
extends JavaModelOperation {
    protected TypeHierarchy typeHierarchy;

    public CreateTypeHierarchyOperation(IRegion region, ICompilationUnit[] workingCopies, IType element, boolean computeSubtypes) {
        super(element);
        this.typeHierarchy = new RegionBasedTypeHierarchy(region, workingCopies, element, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, ICompilationUnit[] workingCopies, IJavaSearchScope scope, boolean computeSubtypes) {
        super(element);
        ICompilationUnit[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new ICompilationUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, scope, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, ICompilationUnit[] workingCopies, IJavaProject project, boolean computeSubtypes) {
        super(element);
        ICompilationUnit[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new ICompilationUnit[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, project, computeSubtypes);
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        this.typeHierarchy.refresh(this);
    }

    public ITypeHierarchy getResult() {
        return this.typeHierarchy;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public IJavaModelStatus verify() {
        IJavaElement elementToProcess = this.getElementToProcess();
        if (elementToProcess == null && !(this.typeHierarchy instanceof RegionBasedTypeHierarchy)) {
            return new JavaModelStatus(968);
        }
        if (elementToProcess != null && !elementToProcess.exists()) {
            return new JavaModelStatus(969, elementToProcess);
        }
        IJavaProject project = this.typeHierarchy.javaProject();
        if (project != null && !project.exists()) {
            return new JavaModelStatus(969, project);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

