/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaCore;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.DeltaProcessingState;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.DeltaProcessor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Messages;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class ExternalFoldersManager {
    private static final boolean WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private Map<IPath, IFolder> folders;
    private Set<IPath> pendingFolders;
    private final AtomicInteger counter = new AtomicInteger(0);
    private static ExternalFoldersManager MANAGER;
    private RefreshJob refreshJob;

    private ExternalFoldersManager() {
        if (Platform.isRunning()) {
            class InitializeFolders
            extends WorkspaceJob {
                public InitializeFolders() {
                    super("Initialize external folders");
                }

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    ExternalFoldersManager.this.getFolders();
                    return Status.OK_STATUS;
                }
            }
            InitializeFolders initializeFolders = new InitializeFolders();
            IProject project = this.getExternalFoldersProject();
            initializeFolders.setRule((ISchedulingRule)project);
            initializeFolders.schedule();
        }
    }

    public static synchronized ExternalFoldersManager getExternalFoldersManager() {
        if (MANAGER == null) {
            MANAGER = new ExternalFoldersManager();
        }
        return MANAGER;
    }

    public static Set<IPath> getExternalFolders(IClasspathEntry[] classpath) {
        if (classpath == null) {
            return null;
        }
        LinkedHashSet<IPath> folders = null;
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 1) {
                IPath attachmentPath;
                IPath entryPath = entry.getPath();
                if (ExternalFoldersManager.isExternalFolderPath(entryPath)) {
                    if (folders == null) {
                        folders = new LinkedHashSet<IPath>();
                    }
                    folders.add(entryPath);
                }
                if (ExternalFoldersManager.isExternalFolderPath(attachmentPath = entry.getSourceAttachmentPath())) {
                    if (folders == null) {
                        folders = new LinkedHashSet();
                    }
                    folders.add(attachmentPath);
                }
            }
            ++i;
        }
        return folders;
    }

    public static boolean isExternalFolderPath(IPath externalPath) {
        if (externalPath == null || externalPath.isEmpty()) {
            return false;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (manager.isExternalFile(externalPath) || manager.isAssumedExternalFile(externalPath)) {
            return false;
        }
        if (!externalPath.isAbsolute() || WINDOWS && externalPath.getDevice() == null && !externalPath.isUNC()) {
            return false;
        }
        File externalFolder = externalPath.toFile();
        if (Files.isRegularFile(externalFolder.toPath(), new LinkOption[0])) {
            manager.addExternalFile(externalPath);
            return false;
        }
        if (Files.isDirectory(externalFolder.toPath(), new LinkOption[0])) {
            return true;
        }
        if (ExternalFoldersManager.isInternalFilePath(externalPath)) {
            return false;
        }
        if (ExternalFoldersManager.isInternalContainerPath(externalPath)) {
            return false;
        }
        if (externalPath.getFileExtension() != null) {
            manager.addAssumedExternalFile(externalPath);
            return false;
        }
        return true;
    }

    private static boolean isInternalFilePath(IPath path) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        return path.segmentCount() > 1 && wsRoot.getFile(path).exists();
    }

    private static boolean isInternalContainerPath(IPath path) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        int segmentCount = path.segmentCount();
        if (segmentCount == 1 && wsRoot.getProject(path.segment(0)).exists()) {
            return true;
        }
        return segmentCount > 1 && wsRoot.getFolder(path).exists();
    }

    public static boolean isInternalPathForExternalFolder(IPath resourcePath) {
        return ".io.spring.javaformat.eclipse.jdt.jdk8.core.external.folders".equals(resourcePath.segment(0));
    }

    public IFolder addFolder(IPath externalFolderPath, boolean scheduleForCreation) {
        return this.addFolder(externalFolderPath, this.getExternalFoldersProject(), scheduleForCreation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFolder addFolder(IPath externalFolderPath, IProject externalFoldersProject, boolean scheduleForCreation) {
        IFolder result;
        IFolder existing;
        Map<IPath, IFolder> knownFolders = this.getFolders();
        ExternalFoldersManager externalFoldersManager = this;
        synchronized (externalFoldersManager) {
            existing = knownFolders.get(externalFolderPath);
            if (existing != null) {
                return existing;
            }
        }
        while ((result = externalFoldersProject.getFolder(".link" + this.counter.incrementAndGet())).exists()) {
        }
        ExternalFoldersManager externalFoldersManager2 = this;
        synchronized (externalFoldersManager2) {
            if (scheduleForCreation) {
                if (this.pendingFolders == null) {
                    this.pendingFolders = new LinkedHashSet<IPath>();
                }
                this.pendingFolders.add(externalFolderPath);
            }
            if ((existing = knownFolders.get(externalFolderPath)) != null) {
                return existing;
            }
            knownFolders.put(externalFolderPath, result);
        }
        return result;
    }

    public synchronized boolean removePendingFolder(Object externalPath) {
        if (this.pendingFolders == null) {
            return false;
        }
        return this.pendingFolders.remove(externalPath);
    }

    public IFolder createLinkFolder(IPath externalFolderPath, boolean refreshIfExistAlready, IProgressMonitor monitor) throws CoreException {
        IProject externalFoldersProject = this.createExternalFoldersProject(monitor);
        return this.createLinkFolder(externalFolderPath, refreshIfExistAlready, externalFoldersProject, monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IFolder createLinkFolder(IPath externalFolderPath, boolean refreshIfExistAlready, IProject externalFoldersProject, IProgressMonitor monitor) throws CoreException {
        IFolder result = this.addFolder(externalFolderPath, externalFoldersProject, false);
        if (!result.exists()) {
            try {
                result.createLink(externalFolderPath, 16, monitor);
                return result;
            }
            catch (CoreException e) {
                if (result.exists()) return result;
                throw e;
            }
        } else {
            if (!refreshIfExistAlready) return result;
            result.refreshLocal(2, monitor);
        }
        return result;
    }

    public void cleanUp(IProgressMonitor monitor) throws CoreException {
        List<Map.Entry<IPath, IFolder>> toDelete = this.getFoldersToCleanUp(monitor);
        if (toDelete == null) {
            return;
        }
        for (Map.Entry<IPath, IFolder> entry : toDelete) {
            IFolder folder = entry.getValue();
            folder.delete(true, monitor);
            IPath key = entry.getKey();
            this.folders.remove(key);
        }
        IProject project = this.getExternalFoldersProject();
        if (project.isAccessible() && project.members().length == 1) {
            project.delete(true, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map.Entry<IPath, IFolder>> getFoldersToCleanUp(IProgressMonitor monitor) throws CoreException {
        DeltaProcessingState state = JavaModelManager.getDeltaState();
        Map<IPath, DeltaProcessor.RootInfo> roots = state.roots;
        Map<IPath, IPath> sourceAttachments = state.sourceAttachments;
        if (roots == null && sourceAttachments == null) {
            return null;
        }
        Map<IPath, IFolder> knownFolders = this.getFolders();
        ArrayList<Map.Entry<IPath, IFolder>> result = null;
        Map<IPath, IFolder> map = knownFolders;
        synchronized (map) {
            for (Map.Entry<IPath, IFolder> entry : knownFolders.entrySet()) {
                IPath path = entry.getKey();
                if (roots == null || roots.containsKey(path) || sourceAttachments == null || sourceAttachments.containsKey(path) || entry.getValue() == null) continue;
                if (result == null) {
                    result = new ArrayList<Map.Entry<IPath, IFolder>>();
                }
                result.add(entry);
            }
        }
        return result;
    }

    public IProject getExternalFoldersProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(".io.spring.javaformat.eclipse.jdt.jdk8.core.external.folders");
    }

    public IProject createExternalFoldersProject(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getExternalFoldersProject();
        if (!project.isAccessible()) {
            if (!project.exists()) {
                this.createExternalFoldersProject(project, monitor);
            }
            this.openExternalFoldersProject(project, monitor);
        }
        return project;
    }

    private void openExternalFoldersProject(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            project.open(monitor);
        }
        catch (CoreException e1) {
            if (e1.getStatus().getCode() == 567) {
                project.delete(false, true, monitor);
                this.createExternalFoldersProject(project, monitor);
            } else {
                IPath stateLocation = JavaCore.getPlugin().getStateLocation();
                IPath projectPath = stateLocation.append(".io.spring.javaformat.eclipse.jdt.jdk8.core.external.folders");
                try {
                    Files.createDirectories(projectPath.toFile().toPath(), new FileAttribute[0]);
                    Throwable throwable = null;
                    Object var7_8 = null;
                    try (FileOutputStream output = new FileOutputStream(projectPath.append(".project").toOSString());){
                        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>.org.eclipse.jdt.core.external.folders</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n</projectDescription>".getBytes());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    project.delete(false, true, monitor);
                    this.createExternalFoldersProject(project, monitor);
                }
            }
            project.open(monitor);
        }
    }

    private void createExternalFoldersProject(IProject project, IProgressMonitor monitor) throws CoreException {
        block2: {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            IPath stateLocation = JavaCore.getPlugin().getStateLocation();
            desc.setLocation(stateLocation.append(".io.spring.javaformat.eclipse.jdt.jdk8.core.external.folders"));
            try {
                project.create(desc, 4096, monitor);
            }
            catch (CoreException e) {
                if (project.exists()) break block2;
                throw e;
            }
        }
    }

    public IFolder getFolder(IPath externalFolderPath) {
        return this.getFolders().get(externalFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<IPath, IFolder> getFolders() {
        if (this.folders == null) {
            LinkedHashMap<IPath, IFolder> tempFolders = new LinkedHashMap<IPath, IFolder>();
            IProject project = this.getExternalFoldersProject();
            try {
                IResource[] members;
                if (!project.isAccessible()) {
                    if (project.exists()) {
                        this.openExternalFoldersProject(project, null);
                    } else {
                        this.folders = Collections.synchronizedMap(tempFolders);
                        return this.folders;
                    }
                }
                IResource[] iResourceArray = members = project.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member.getType() == 2 && member.isLinked() && member.getName().startsWith(".link")) {
                        IPath externalFolderPath = member.getLocation();
                        tempFolders.put(externalFolderPath, (IFolder)member);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Util.log(e, "Exception while initializing external folders");
            }
            ExternalFoldersManager externalFoldersManager = this;
            synchronized (externalFoldersManager) {
                if (this.folders == null) {
                    this.folders = Collections.synchronizedMap(tempFolders);
                }
            }
        }
        return this.folders;
    }

    private synchronized void runRefreshJob(Collection<IPath> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        if (this.refreshJob == null) {
            this.refreshJob = new RefreshJob();
        }
        this.refreshJob.addFoldersToRefresh(paths);
    }

    public void refreshReferences(IProject[] sourceProjects, IProgressMonitor monitor) {
        IProject externalProject = this.getExternalFoldersProject();
        try {
            LinkedHashSet<IPath> externalFolders = null;
            int index = 0;
            while (index < sourceProjects.length) {
                Set<IPath> foldersInProject;
                if (!sourceProjects[index].equals((Object)externalProject) && JavaProject.hasJavaNature(sourceProjects[index]) && (foldersInProject = ExternalFoldersManager.getExternalFolders(((JavaProject)JavaCore.create(sourceProjects[index])).getResolvedClasspath())) != null && foldersInProject.size() != 0) {
                    if (externalFolders == null) {
                        externalFolders = new LinkedHashSet<IPath>();
                    }
                    externalFolders.addAll(foldersInProject);
                }
                ++index;
            }
            this.runRefreshJob(externalFolders);
        }
        catch (CoreException e) {
            Util.log(e, "Exception while refreshing external project");
        }
    }

    static class RefreshJob
    extends Job {
        final LinkedHashSet<IPath> externalFolders;

        RefreshJob() {
            super(Messages.refreshing_external_folders);
            this.setSystem(true);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.setRule(workspace.getRuleFactory().refreshRule((IResource)workspace.getRoot()));
            this.externalFolders = new LinkedHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFoldersToRefresh(Collection<IPath> paths) {
            boolean shouldSchedule;
            LinkedHashSet<IPath> linkedHashSet = this.externalFolders;
            synchronized (linkedHashSet) {
                this.externalFolders.addAll(paths);
                shouldSchedule = !this.externalFolders.isEmpty();
            }
            if (shouldSchedule) {
                this.schedule();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor pm) {
            MultiStatus errors = new MultiStatus("io.spring.javaformat.eclipse.jdt.jdk8.core", 0, "Exception while refreshing external folders", null);
            while (true) {
                LinkedHashSet<IPath> linkedHashSet;
                IPath externalPath;
                LinkedHashSet<IPath> linkedHashSet2 = this.externalFolders;
                synchronized (linkedHashSet2) {
                    if (this.externalFolders.isEmpty()) {
                        return errors.isOK() ? Status.OK_STATUS : errors;
                    }
                    externalPath = (IPath)this.externalFolders.iterator().next();
                }
                try {
                    try {
                        IFolder folder = ExternalFoldersManager.getExternalFoldersManager().getFolder(externalPath);
                        if (folder != null) {
                            folder.refreshLocal(2, pm);
                        }
                    }
                    catch (CoreException e) {
                        errors.merge(e.getStatus());
                        linkedHashSet = this.externalFolders;
                        synchronized (linkedHashSet) {
                            this.externalFolders.remove(externalPath);
                            continue;
                        }
                    }
                }
                catch (Throwable throwable) {
                    linkedHashSet = this.externalFolders;
                    synchronized (linkedHashSet) {
                        this.externalFolders.remove(externalPath);
                    }
                    throw throwable;
                }
                linkedHashSet = this.externalFolders;
                synchronized (linkedHashSet) {
                    this.externalFolders.remove(externalPath);
                }
            }
        }
    }
}

