/*
 * Decompiled with CFR 0.152.
 */
package strikt.internal.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import strikt.api.Status;
import strikt.internal.AssertionGroup;
import strikt.internal.AssertionNode;
import strikt.internal.AssertionResult;
import strikt.internal.AssertionSubject;
import strikt.internal.ComparedValues;
import strikt.internal.DescribedNode;
import strikt.internal.reporting.DefaultResultWriterKt;
import strikt.internal.reporting.FormattingKt;
import strikt.internal.reporting.ResultWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0014J(\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u000f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J \u0010\u0010\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0014J\u0014\u0010\u0011\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0014J \u0010\u0012\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J*\u0010\u0013\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\t2\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0016H\u0002J$\u0010\u0017\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00182\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u0019\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u001a2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001b"}, d2={"Lstrikt/internal/reporting/DefaultResultWriter;", "Lstrikt/internal/reporting/ResultWriter;", "()V", "writeIndented", "", "writer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "node", "Lstrikt/internal/AssertionNode;", "indent", "", "writeLine", "writeLineEnd", "writeLineStart", "writePathTo", "writeStatusIcon", "writeSubjectIcon", "writeTo", "addAncestorsTo", "S", "tree", "", "writeResult", "Lstrikt/internal/AssertionResult;", "writeSubject", "Lstrikt/internal/AssertionSubject;", "strikt-core"})
public class DefaultResultWriter
implements ResultWriter {
    @Override
    public void writeTo(@NotNull Appendable writer, @NotNull AssertionNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        DefaultResultWriter.writeIndented$default(this, writer, node, 0, 4, null);
    }

    @Override
    public void writePathTo(@NotNull Appendable writer, @NotNull AssertionNode<?> node) {
        ListIterator listIterator;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        List tree = new ArrayList();
        this.addAncestorsTo(node, tree);
        ListIterator iterator = listIterator = tree.listIterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            int indent = iterator.nextIndex();
            AssertionNode n = (AssertionNode)iterator.next();
            this.writeLine(writer, n, indent);
            this.writeLineEnd(writer, n);
        }
        this.writeIndented(writer, node, tree.size());
    }

    private final <S> void addAncestorsTo(AssertionNode<S> $this$addAncestorsTo, List<AssertionNode<?>> tree) {
        AssertionGroup<?> assertionGroup = $this$addAncestorsTo.getParent();
        if (assertionGroup != null) {
            AssertionGroup<?> assertionGroup2;
            AssertionGroup<?> it = assertionGroup2 = assertionGroup;
            boolean bl = false;
            if (it instanceof DescribedNode) {
                tree.add(0, it);
            }
            this.addAncestorsTo(it, tree);
        }
    }

    private final void writeIndented(Appendable writer, AssertionNode<?> node, int indent) {
        this.writeLine(writer, node, indent);
        if (node instanceof AssertionGroup) {
            Iterable<AssertionNode<?>> $this$forEach$iv = ((AssertionGroup)node).getChildren();
            boolean $i$f$forEach = false;
            Iterator<AssertionNode<?>> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                AssertionNode<?> element$iv;
                AssertionNode<?> it = element$iv = iterator.next();
                boolean bl = false;
                this.writeLineEnd(writer, it);
                this.writeIndented(writer, it, node instanceof DescribedNode ? indent + 1 : indent);
            }
        }
    }

    static /* synthetic */ void writeIndented$default(DefaultResultWriter defaultResultWriter, Appendable appendable, AssertionNode assertionNode, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeIndented");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        defaultResultWriter.writeIndented(appendable, assertionNode, n);
    }

    protected void writeLine(@NotNull Appendable writer, @NotNull AssertionNode<?> node, int indent) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        AssertionNode<?> assertionNode = node;
        if (assertionNode instanceof AssertionSubject) {
            this.writeSubject((AssertionSubject)node, writer, indent);
        } else if (assertionNode instanceof AssertionResult) {
            this.writeResult((AssertionResult)node, writer, indent);
        }
    }

    private final void writeSubject(AssertionSubject<?> $this$writeSubject, Appendable writer, int indent) {
        this.writeLineStart(writer, (AssertionNode)$this$writeSubject, indent);
        this.writeSubjectIcon(writer);
        if ($this$writeSubject.isRoot()) {
            writer.append("Expect that ");
        }
        int valueIndent = RangesKt.coerceAtLeast((int)StringsKt.indexOf$default((CharSequence)$this$writeSubject.getDescription(), (String)"%", (int)0, (boolean)false, (int)6, null), (int)0) + 14 + indent * 2;
        Object formattedValue = FormattingKt.formatValue($this$writeSubject.getSubject());
        Object[] objectArray = new Object[]{formattedValue};
        String string = String.format($this$writeSubject.getDescription(), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
        writer.append(CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)string), (CharSequence)('\n' + StringsKt.padStart$default((String)"", (int)valueIndent, (char)'\u0000', (int)2, null) + '|'), null, null, (int)0, null, null, (int)62, null)).append(":");
    }

    private final void writeResult(AssertionResult<?> $this$writeResult, Appendable writer, int indent) {
        this.writeLineStart(writer, (AssertionNode)$this$writeResult, indent);
        this.writeStatusIcon(writer, (AssertionNode)$this$writeResult);
        Status status = $this$writeResult.getStatus();
        Status.Failed failed = status instanceof Status.Failed ? (Status.Failed)status : null;
        Status.Failed failed2 = failed;
        if ((failed2 == null ? null : failed2.getComparison()) != null) {
            Object it;
            ComparedValues formattedComparison = FormattingKt.formatValues(failed.getComparison());
            String string = failed.getDescription();
            if (string == null) {
                string = "found %s";
            }
            String failedDescription = string;
            int descriptionIndent = StringsKt.indexOf$default((CharSequence)$this$writeResult.getDescription(), (String)"%", (int)0, (boolean)false, (int)6, null);
            int descriptionIndentFollowing = descriptionIndent + indent * 2 + 2;
            int alignIndent = RangesKt.coerceAtLeast((int)(descriptionIndent - StringsKt.indexOf$default((CharSequence)failedDescription, (String)"%", (int)0, (boolean)false, (int)6, null) + 2), (int)2);
            int alignIndentFollowing = alignIndent + StringsKt.indexOf$default((CharSequence)failedDescription, (String)"%", (int)0, (boolean)false, (int)6, null) + indent * 2;
            Object object = new Object[]{formattedComparison.getExpected()};
            String string2 = String.format($this$writeResult.getDescription(), Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            object = string2;
            Appendable appendable = writer;
            boolean $i$a$-let-DefaultResultWriter$writeResult$32 = false;
            List lines = StringsKt.lines((CharSequence)((CharSequence)it));
            appendable.append((CharSequence)(lines.size() > 1 ? CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)('\n' + StringsKt.padStart$default((String)"", (int)descriptionIndentFollowing, (char)'\u0000', (int)2, null) + '|'), null, null, (int)0, null, null, (int)62, null) : it)).append("\n");
            this.writeLineStart(writer, (AssertionNode)$this$writeResult, indent);
            Appendable appendable2 = writer.append(StringsKt.padEnd$default((String)"", (int)alignIndent, (char)'\u0000', (int)2, null));
            it = new Object[]{formattedComparison.getActual()};
            String $i$a$-let-DefaultResultWriter$writeResult$32 = String.format(failedDescription, Arrays.copyOf(it, ((Object[])it).length));
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-let-DefaultResultWriter$writeResult$32, (String)"format(this, *args)");
            it = $i$a$-let-DefaultResultWriter$writeResult$32;
            appendable = appendable2;
            boolean bl = false;
            lines = StringsKt.lines((CharSequence)((CharSequence)it));
            appendable.append((CharSequence)(lines.size() > 1 ? CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)('\n' + StringsKt.padStart$default((String)"", (int)alignIndentFollowing, (char)'\u0000', (int)2, null) + '|'), null, null, (int)0, null, null, (int)62, null) : it));
        } else {
            Status.Failed failed3 = failed;
            if ((failed3 == null ? null : failed3.getDescription()) != null) {
                Object[] objectArray = new Object[]{FormattingKt.formatValue($this$writeResult.getExpected())};
                String string = String.format($this$writeResult.getDescription(), Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
                writer.append(string).append(" : ").append(failed.getDescription());
            } else {
                Object[] objectArray = new Object[]{FormattingKt.formatValue($this$writeResult.getExpected())};
                String string = String.format($this$writeResult.getDescription(), Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
                writer.append(string);
            }
        }
    }

    protected void writeLineStart(@NotNull Appendable writer, @NotNull AssertionNode<?> node, int indent) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (node instanceof DescribedNode) {
            writer.append(StringsKt.padStart$default((String)"", (int)(2 * indent), (char)'\u0000', (int)2, null));
        }
    }

    protected void writeLineEnd(@NotNull Appendable writer, @NotNull AssertionNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (node instanceof DescribedNode) {
            writer.append(DefaultResultWriterKt.access$getEOL$p());
        }
    }

    protected void writeStatusIcon(@NotNull Appendable writer, @NotNull AssertionNode<?> node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Status status = node.getStatus();
        if (status instanceof Status.Passed) {
            string = "\u2713 ";
        } else if (status instanceof Status.Failed) {
            string = "\u2717 ";
        } else if (status instanceof Status.Pending) {
            string = "? ";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        writer.append(string);
    }

    protected void writeSubjectIcon(@NotNull Appendable writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.append("\u25bc ");
    }
}

