/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.annotations;

import java.util.Objects;

public class VersionRange<Version extends Comparable<Version>> {
    private static final VersionRange EMPTY = new VersionRange<Object>(null, null);
    private final Version from;
    private final Version to;

    public static <Version extends Comparable<Version>> VersionRange<Version> empty() {
        return EMPTY;
    }

    public static <Version extends Comparable<Version>> VersionRange<Version> all() {
        return new VersionRange<Object>(null, null);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isAll() {
        return this.equals(VersionRange.all());
    }

    private VersionRange(Version from, Version to) {
        if (from == null && to != null) {
            throw new IllegalArgumentException();
        }
        if (from != null && to != null && from.compareTo(to) > 0) {
            throw new IllegalArgumentException("Bad version range");
        }
        this.from = from;
        this.to = to;
    }

    static <Version extends Comparable<Version>> VersionRange<Version> parse(String versionRange, VersionParser<Version> parser) {
        if ("empty".equals(versionRange)) {
            return VersionRange.empty();
        }
        if ("all".equals(versionRange)) {
            return VersionRange.all();
        }
        if (parser.isValid(versionRange)) {
            Version v = parser.parse(versionRange);
            return new VersionRange<Version>(v, v);
        }
        if (versionRange.endsWith("+")) {
            String s1 = versionRange.substring(0, versionRange.length() - 1);
            if (parser.isValid(s1)) {
                Version v = parser.parse(s1);
                return new VersionRange<Object>(v, null);
            }
            throw new IllegalArgumentException("Invalid from version " + s1);
        }
        int index = versionRange.indexOf(45);
        if (index != -1) {
            String from = versionRange.substring(0, index);
            String to = versionRange.substring(index + 1);
            if (parser.isValid(from)) {
                if (parser.isValid(to)) {
                    return new VersionRange<Version>(parser.parse(from), parser.parse(to));
                }
                throw new IllegalArgumentException("Invalid to version " + to);
            }
            throw new IllegalArgumentException("Invalid from version " + from);
        }
        throw new IllegalArgumentException("Invalid version range: None of the expected patterns applied");
    }

    public Version lower() {
        return this.from;
    }

    public Version upper() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionRange that = (VersionRange)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public boolean contains(Version apiVersion) {
        return this != EMPTY && apiVersion != null && (this.from == null || this.from.compareTo(apiVersion) <= 0 && (this.to == null || this.to.compareTo(apiVersion) >= 0));
    }

    public boolean intersects(VersionRange<Version> other) {
        if (this == EMPTY) {
            return false;
        }
        if (this.from == null) {
            return true;
        }
        if (this.to == null) {
            return this.from.compareTo(other.from) <= 0;
        }
        return this.to.compareTo(other.from) >= 0 && (other.to == null || this.from.compareTo(other.to) <= 0);
    }

    public String toString() {
        if (this == EMPTY) {
            return "empty";
        }
        if (this.from == null) {
            return "all";
        }
        if (this.to == null) {
            return this.from + "+";
        }
        if (this.from.equals(this.to)) {
            return this.from.toString();
        }
        return this.from + "-" + this.to;
    }

    static interface VersionParser<Version extends Comparable<Version>> {
        public Version parse(String var1) throws IllegalArgumentException;

        default public boolean isValid(String version) {
            try {
                this.parse(version);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

