/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.crdgenerator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.annotations.ApiVersion;
import io.strimzi.api.annotations.KubeVersion;
import io.strimzi.api.annotations.VersionRange;
import io.strimzi.crdgenerator.DocGenerator;
import io.strimzi.crdgenerator.Property;
import io.strimzi.crdgenerator.PropertyType;
import io.strimzi.crdgenerator.Schema;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Example;
import io.strimzi.crdgenerator.annotations.Maximum;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.MinimumItems;
import io.strimzi.crdgenerator.annotations.OneOf;
import io.strimzi.crdgenerator.annotations.Pattern;
import io.strimzi.crdgenerator.annotations.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

class CrdGenerator {
    public static final YAMLMapper YAML_MAPPER = new YAMLMapper().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.SPLIT_LINES, false).configure(YAMLGenerator.Feature.LITERAL_BLOCK_STYLE, true).configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
    public static final ObjectMapper JSON_MATTER = new ObjectMapper();
    private final ApiVersion crdApiVersion;
    private final List<ApiVersion> generateVersions;
    private final ApiVersion storageVersion;
    private final VersionRange<ApiVersion> servedVersion;
    private final VersionRange<ApiVersion> describeVersions;
    Reporter reporter;
    private final VersionRange<KubeVersion> targetKubeVersions;
    private final ObjectMapper mapper;
    private final JsonNodeFactory nf;
    private final Map<String, String> labels;
    private final ConversionStrategy conversionStrategy;
    private int numErrors;

    public void warn(String s) {
        this.reporter.warn(s);
    }

    public static void argParseErr(String s) {
        System.err.println("CrdGenerator: error: " + s);
    }

    public void err(String s) {
        this.reporter.err(s);
        ++this.numErrors;
    }

    public CrdGenerator(VersionRange<KubeVersion> targetKubeVersions, ApiVersion crdApiVersion) {
        this(targetKubeVersions, crdApiVersion, YAML_MAPPER, Collections.emptyMap(), new DefaultReporter(), Collections.emptyList(), null, null, new NoneConversionStrategy(), null);
    }

    public CrdGenerator(VersionRange<KubeVersion> targetKubeVersions, ApiVersion crdApiVersion, ObjectMapper mapper, Map<String, String> labels, Reporter reporter, List<ApiVersion> apiVersions, ApiVersion storageVersion, VersionRange<ApiVersion> servedVersions, ConversionStrategy conversionStrategy, VersionRange<ApiVersion> describeVersions) {
        this.reporter = reporter;
        if (targetKubeVersions.isEmpty() || targetKubeVersions.isAll()) {
            this.err("Target kubernetes version cannot be empty or all");
        }
        this.targetKubeVersions = targetKubeVersions;
        this.crdApiVersion = crdApiVersion;
        this.mapper = mapper;
        this.nf = mapper.getNodeFactory();
        this.labels = labels;
        this.generateVersions = apiVersions;
        this.describeVersions = describeVersions;
        this.storageVersion = storageVersion;
        this.servedVersion = servedVersions;
        this.conversionStrategy = conversionStrategy;
    }

    public int generate(Class<? extends CustomResource> crdClass, Writer out) throws IOException {
        ObjectNode node = this.nf.objectNode();
        Crd crd = crdClass.getAnnotation(Crd.class);
        if (crd == null) {
            this.err(crdClass + " is not annotated with @Crd");
        } else {
            node.put("apiVersion", "apiextensions.k8s.io/" + this.crdApiVersion).put("kind", "CustomResourceDefinition").putObject("metadata").put("name", crd.spec().names().plural() + "." + crd.spec().group());
            if (!this.labels.isEmpty()) {
                ((ObjectNode)node.get("metadata")).putObject("labels").setAll(this.labels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new TextNode(((String)e.getValue()).replace("%group%", crd.spec().group()).replace("%plural%", crd.spec().names().plural()).replace("%singular%", crd.spec().names().singular())), (x, y) -> x, LinkedHashMap::new)));
            }
            node.set("spec", this.buildSpec(this.crdApiVersion, crd.spec(), crdClass));
        }
        this.mapper.writeValue(out, (Object)node);
        return this.numErrors;
    }

    private ObjectNode buildSpec(ApiVersion crdApiVersion, Crd.Spec crd, Class<? extends CustomResource> crdClass) {
        ObjectNode result = this.nf.objectNode();
        result.put("group", crd.group());
        ArrayNode versions = this.nf.arrayNode();
        Map<ApiVersion, ObjectNode> subresources = this.buildSubresources(crd);
        Map<ApiVersion, ObjectNode> schemas = this.buildSchemas(crd, crdClass);
        Map<ApiVersion, ArrayNode> printerColumns = this.buildPrinterColumns(crd);
        result.set("names", this.buildNames(crd.names()));
        result.put("scope", crd.scope());
        if (this.conversionStrategy instanceof WebhookConversionStrategy) {
            result.put("preserveUnknownFields", false);
        }
        result.set("conversion", this.buildConversion(crdApiVersion));
        for (Crd.Spec.Version version : crd.versions()) {
            ArrayNode cols;
            ApiVersion crApiVersion = ApiVersion.parse(version.name());
            if (!this.shouldIncludeVersion(crApiVersion)) continue;
            ObjectNode versionNode = versions.addObject();
            versionNode.put("name", crApiVersion.toString());
            versionNode.put("served", this.servedVersion != null ? this.servedVersion.contains(crApiVersion) : version.served());
            versionNode.put("storage", this.storageVersion != null ? crApiVersion.equals(this.storageVersion) : version.storage());
            ObjectNode subresourcesForVersion = subresources.get(crApiVersion);
            if (!subresourcesForVersion.isEmpty()) {
                versionNode.set("subresources", subresourcesForVersion);
            }
            if (!(cols = printerColumns.get(crApiVersion)).isEmpty()) {
                versionNode.set("additionalPrinterColumns", cols);
            }
            versionNode.set("schema", schemas.get(crApiVersion));
        }
        result.set("versions", versions);
        if (crdApiVersion.compareTo(ApiVersion.V1) < 0 && this.targetKubeVersions.intersects(KubeVersion.parseRange("1.11-1.15"))) {
            result.put("version", Arrays.stream(crd.versions()).map(v -> ApiVersion.parse(v.name())).filter(this::shouldIncludeVersion).findFirst().map(ApiVersion::toString).orElseThrow());
        }
        return result;
    }

    private ObjectNode buildConversion(ApiVersion crdApiVersion) {
        ObjectNode conversion = this.nf.objectNode();
        if (this.conversionStrategy instanceof NoneConversionStrategy) {
            conversion.put("strategy", "None");
        } else if (this.conversionStrategy instanceof WebhookConversionStrategy) {
            conversion.put("strategy", "Webhook");
            WebhookConversionStrategy webhookStrategy = (WebhookConversionStrategy)this.conversionStrategy;
            ObjectNode webhook = conversion.putObject("webhook");
            webhook.putArray("conversionReviewVersions").add("v1").add("v1beta1");
            ObjectNode webhookClientConfig = webhook.putObject("clientConfig");
            webhookClientConfig.put("caBundle", webhookStrategy.caBundle);
            if (webhookStrategy.isUrl()) {
                webhookClientConfig.put("url", webhookStrategy.url);
            } else {
                webhookClientConfig.putObject("service").put("name", webhookStrategy.name).put("namespace", webhookStrategy.namespace).put("path", webhookStrategy.path).put("port", webhookStrategy.port);
            }
        } else {
            throw new IllegalStateException();
        }
        return conversion;
    }

    private Map<ApiVersion, ObjectNode> buildSchemas(Crd.Spec crd, Class<? extends CustomResource> crdClass) {
        return Arrays.stream(crd.versions()).map(version -> ApiVersion.parse(version.name())).filter(this::shouldIncludeVersion).collect(Collectors.toMap(Function.identity(), version -> this.buildValidation(crdClass, (ApiVersion)version, this.shouldDescribeVersion((ApiVersion)version))));
    }

    private Map<ApiVersion, ObjectNode> buildSubresources(Crd.Spec crd) {
        return Arrays.stream(crd.versions()).map(version -> ApiVersion.parse(version.name())).filter(this::shouldIncludeVersion).collect(Collectors.toMap(Function.identity(), version -> this.buildSubresources(crd, (ApiVersion)version)));
    }

    private boolean shouldIncludeVersion(ApiVersion version) {
        return this.generateVersions == null || this.generateVersions.isEmpty() || this.generateVersions.contains(version);
    }

    private boolean shouldDescribeVersion(ApiVersion version) {
        return this.describeVersions == null || this.describeVersions.isEmpty() || this.describeVersions.isAll() || this.describeVersions.contains(version);
    }

    private Map<ApiVersion, ArrayNode> buildPrinterColumns(Crd.Spec crd) {
        return Arrays.stream(crd.versions()).map(version -> ApiVersion.parse(version.name())).filter(this::shouldIncludeVersion).collect(Collectors.toMap(Function.identity(), version -> this.buildAdditionalPrinterColumns(crd, (ApiVersion)version)));
    }

    private ObjectNode buildSubresources(Crd.Spec crd, ApiVersion crApiVersion) {
        ObjectNode subresources = this.nf.objectNode();
        if (crd.subresources().status().length != 0) {
            ObjectNode scaleNode;
            ObjectNode status = this.buildStatus(crd, crApiVersion);
            if (status != null) {
                subresources.set("status", status);
            }
            if ((scaleNode = this.buildScale(crd, crApiVersion)) != null) {
                subresources.set("scale", scaleNode);
            }
        }
        return subresources;
    }

    private ObjectNode buildStatus(Crd.Spec crd, ApiVersion crApiVersion) {
        ObjectNode status;
        long length = Arrays.stream(crd.subresources().status()).filter(st -> ApiVersion.parseRange(st.apiVersion()).contains(crApiVersion)).count();
        if (length == 1L) {
            status = this.nf.objectNode();
        } else if (length > 1L) {
            this.err("Each custom resource definition can have only one status sub-resource.");
            status = null;
        } else {
            status = null;
        }
        return status;
    }

    private ObjectNode buildScale(Crd.Spec crd, ApiVersion crApiVersion) {
        ObjectNode scaleNode;
        Crd.Spec.Subresources.Scale[] scales = crd.subresources().scale();
        List filteredScales = Arrays.stream(scales).filter(sc -> ApiVersion.parseRange(sc.apiVersion()).contains(crApiVersion)).collect(Collectors.toList());
        if (filteredScales.size() == 1) {
            scaleNode = this.nf.objectNode();
            Crd.Spec.Subresources.Scale scale = (Crd.Spec.Subresources.Scale)filteredScales.get(0);
            scaleNode.put("specReplicasPath", scale.specReplicasPath());
            scaleNode.put("statusReplicasPath", scale.statusReplicasPath());
            if (!scale.labelSelectorPath().isEmpty()) {
                scaleNode.put("labelSelectorPath", scale.labelSelectorPath());
            }
        } else {
            if (filteredScales.size() > 1) {
                throw new RuntimeException("Each custom resource definition can have only one scale sub-resource.");
            }
            scaleNode = null;
        }
        return scaleNode;
    }

    private ArrayNode buildAdditionalPrinterColumns(Crd.Spec crd, ApiVersion crApiVersion) {
        ArrayNode cols = this.nf.arrayNode();
        if (crd.additionalPrinterColumns().length != 0) {
            for (Crd.Spec.AdditionalPrinterColumn col2 : Arrays.stream(crd.additionalPrinterColumns()).filter(col -> crApiVersion == null || ApiVersion.parseRange(col.apiVersion()).contains(crApiVersion)).collect(Collectors.toList())) {
                ObjectNode colNode = cols.addObject();
                colNode.put("name", col2.name());
                colNode.put("description", col2.description());
                colNode.put(this.crdApiVersion.compareTo(ApiVersion.V1) >= 0 ? "jsonPath" : "JSONPath", col2.jsonPath());
                colNode.put("type", col2.type());
                if (col2.priority() != 0) {
                    colNode.put("priority", col2.priority());
                }
                if (col2.format().isEmpty()) continue;
                colNode.put("format", col2.format());
            }
        }
        return cols;
    }

    private JsonNode buildNames(Crd.Spec.Names names) {
        ObjectNode result = this.nf.objectNode();
        String kind = names.kind();
        result.put("kind", kind);
        Object listKind = names.listKind();
        if (((String)listKind).isEmpty()) {
            listKind = kind + "List";
        }
        result.put("listKind", (String)listKind);
        String singular = names.singular();
        if (singular.isEmpty()) {
            singular = kind.toLowerCase(Locale.US);
        }
        result.put("singular", singular);
        result.put("plural", names.plural());
        if (names.shortNames().length > 0) {
            result.set("shortNames", this.stringArray(Arrays.asList(names.shortNames())));
        }
        if (names.categories().length > 0) {
            result.set("categories", this.stringArray(Arrays.asList(names.categories())));
        }
        return result;
    }

    private ObjectNode buildValidation(Class<? extends CustomResource> crdClass, ApiVersion crApiVersion, boolean description) {
        ObjectNode result = this.nf.objectNode();
        boolean noTopLevelTypeProperty = this.targetKubeVersions.intersects(KubeVersion.parseRange("1.11-1.15"));
        result.set("openAPIV3Schema", this.buildObjectSchema(crApiVersion, crdClass, this.crdApiVersion.compareTo(ApiVersion.V1) >= 0 || !noTopLevelTypeProperty, description));
        return result;
    }

    private ObjectNode buildObjectSchema(ApiVersion crApiVersion, Class<?> crdClass, boolean description) {
        return this.buildObjectSchema(crApiVersion, crdClass, true, description);
    }

    private ObjectNode buildObjectSchema(ApiVersion crApiVersion, Class<?> crdClass, boolean printType, boolean description) {
        ObjectNode result = this.nf.objectNode();
        this.buildObjectSchema(crApiVersion, result, crdClass, printType, description);
        return result;
    }

    private void buildObjectSchema(ApiVersion crApiVersion, ObjectNode result, Class<?> crdClass, boolean printType, boolean description) {
        ArrayNode required;
        this.checkClass(crdClass);
        if (printType) {
            result.put("type", "object");
        }
        result.set("properties", this.buildSchemaProperties(crApiVersion, crdClass, description));
        ArrayNode oneOf = this.buildSchemaOneOf(crdClass);
        if (oneOf != null) {
            result.set("oneOf", oneOf);
        }
        if ((required = this.buildSchemaRequired(crApiVersion, crdClass)).size() > 0) {
            result.set("required", required);
        }
    }

    private ArrayNode buildSchemaOneOf(Class<?> crdClass) {
        ArrayNode alternatives;
        OneOf oneOf = crdClass.getAnnotation(OneOf.class);
        if (oneOf != null && oneOf.value().length > 0) {
            alternatives = this.nf.arrayNode();
            for (OneOf.Alternative alt : oneOf.value()) {
                ObjectNode alternative = alternatives.addObject();
                ObjectNode properties = alternative.putObject("properties");
                for (OneOf.Alternative.Property prop : alt.value()) {
                    properties.putObject(prop.value());
                }
                ArrayNode required = alternative.putArray("required");
                for (OneOf.Alternative.Property prop : alt.value()) {
                    if (!prop.required()) continue;
                    required.add(prop.value());
                }
            }
        } else {
            alternatives = null;
        }
        return alternatives;
    }

    private void checkClass(Class<?> crdClass) {
        if (!crdClass.isAnnotationPresent(JsonInclude.class)) {
            this.err(crdClass + " is missing @JsonInclude");
        } else if (!crdClass.getAnnotation(JsonInclude.class).value().equals((Object)JsonInclude.Include.NON_NULL) && !crdClass.getAnnotation(JsonInclude.class).value().equals((Object)JsonInclude.Include.NON_DEFAULT)) {
            this.err(crdClass + " has a @JsonInclude value other than Include.NON_NULL");
        }
        if (!Modifier.isAbstract(crdClass.getModifiers())) {
            this.checkForBuilderClass(crdClass, crdClass.getName() + "Builder");
            this.checkForBuilderClass(crdClass, crdClass.getName() + "Fluent");
        }
        if (!Modifier.isAbstract(crdClass.getModifiers())) {
            Property.hasAnyGetterAndAnySetter(crdClass);
        } else {
            for (Class<?> c : Property.subtypes(crdClass)) {
                Property.hasAnyGetterAndAnySetter(c);
                this.checkDiscriminatorIsIncluded(crdClass, c);
            }
        }
        this.checkInherits(crdClass, "java.io.Serializable");
        if (crdClass.getName().startsWith("io.strimzi.api.")) {
            this.checkInherits(crdClass, "io.strimzi.api.kafka.model.UnknownPropertyPreserving");
        }
        if (!Modifier.isAbstract(crdClass.getModifiers())) {
            this.checkClassOverrides(crdClass, "hashCode", new Class[0]);
        }
        this.checkClassOverrides(crdClass, "equals", Object.class);
    }

    private void checkDiscriminatorIsIncluded(Class<?> crdClass, Class c) {
        try {
            String typePropertyName = crdClass.getAnnotation(JsonTypeInfo.class).property();
            String methodName = "get" + typePropertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + typePropertyName.substring(1).toLowerCase(Locale.ENGLISH);
            Method method = c.getMethod(methodName, new Class[0]);
            if (!this.isAnnotatedWithIncludeNonNull(method)) {
                this.err(c.getCanonicalName() + "#" + methodName + " is not annotated with @JsonInclude(JsonInclude.Include.NON_NULL)");
            }
        }
        catch (NoSuchMethodException e) {
            this.err(e.getMessage());
        }
    }

    private boolean isAnnotatedWithIncludeNonNull(Method method) {
        JsonInclude ann = method.getAnnotation(JsonInclude.class);
        return ann != null && ann.value().equals((Object)JsonInclude.Include.NON_NULL);
    }

    private void checkInherits(Class<?> crdClass, String className) {
        if (!this.inherits(crdClass, className)) {
            this.err(crdClass + " does not inherit " + className);
        }
    }

    private boolean inherits(Class<?> crdClass, String className) {
        Class<?> c = crdClass;
        boolean found = false;
        block0: do {
            if (className.equals(c.getName())) {
                found = true;
                break;
            }
            for (Class<?> i : c.getInterfaces()) {
                if (!this.inherits(i, className)) continue;
                found = true;
                break block0;
            }
        } while ((c = c.getSuperclass()) != null);
        return found;
    }

    private void checkForBuilderClass(Class<?> crdClass, String builderClass) {
        try {
            Class.forName(builderClass, false, crdClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.err(crdClass + " is not annotated with @Buildable (" + builderClass + " does not exist)");
        }
    }

    private void checkClassOverrides(Class<?> crdClass, String methodName, Class<?> ... parameterTypes) {
        try {
            crdClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            this.err(crdClass + " does not override " + methodName);
        }
    }

    private Collection<Property> unionOfSubclassProperties(ApiVersion crApiVersion, Class<?> crdClass) {
        TreeMap<String, Property> result = new TreeMap<String, Property>();
        for (Class<?> subtype : Property.subtypes(crdClass)) {
            result.putAll(Property.properties(crApiVersion, subtype));
        }
        result.putAll(Property.properties(crApiVersion, crdClass));
        JsonPropertyOrder order = crdClass.getAnnotation(JsonPropertyOrder.class);
        return Property.sortedProperties(order != null ? order.value() : null, result).values();
    }

    private ArrayNode buildSchemaRequired(ApiVersion crApiVersion, Class<?> crdClass) {
        ArrayNode result = this.nf.arrayNode();
        for (Property property : this.unionOfSubclassProperties(crApiVersion, crdClass)) {
            if ((!property.isAnnotationPresent(JsonProperty.class) || !property.getAnnotation(JsonProperty.class).required()) && !property.isDiscriminator()) continue;
            result.add(property.getName());
        }
        return result;
    }

    private ObjectNode buildSchemaProperties(ApiVersion crApiVersion, Class<?> crdClass, boolean description) {
        ObjectNode properties = this.nf.objectNode();
        for (Property property : this.unionOfSubclassProperties(crApiVersion, crdClass)) {
            this.buildProperty(crApiVersion, properties, property, description);
        }
        return properties;
    }

    private void buildProperty(ApiVersion crdApiVersion, ObjectNode properties, Property property, boolean description) {
        properties.set(property.getName(), this.buildSchema(crdApiVersion, property, description));
    }

    private ObjectNode buildSchema(ApiVersion crApiVersion, Property property, boolean description) {
        ObjectNode schema;
        PropertyType propertyType = property.getType();
        Class<?> returnType = propertyType.getType();
        if (propertyType.getGenericType() instanceof ParameterizedType && ((ParameterizedType)propertyType.getGenericType()).getRawType().equals(Map.class) && ((ParameterizedType)propertyType.getGenericType()).getActualTypeArguments()[0].equals(Integer.class)) {
            System.err.println("It's OK");
            schema = this.nf.objectNode();
            schema.put("type", "object");
            schema.putObject("patternProperties").set("-?[0-9]+", this.buildArraySchema(crApiVersion, property, new PropertyType(null, ((ParameterizedType)propertyType.getGenericType()).getActualTypeArguments()[1]), description));
        } else {
            schema = Schema.isJsonScalarType(returnType) || Map.class.equals(returnType) ? this.addSimpleTypeConstraints(crApiVersion, this.buildBasicTypeSchema(property, returnType), property) : (returnType.isArray() || List.class.equals(returnType) ? this.buildArraySchema(crApiVersion, property, property.getType(), description) : this.buildObjectSchema(crApiVersion, returnType, description));
        }
        if (description) {
            this.addDescription(crApiVersion, schema, property);
        }
        return schema;
    }

    private ObjectNode buildArraySchema(ApiVersion crApiVersion, Property property, PropertyType propertyType, boolean description) {
        ObjectNode result;
        int arrayDimension = propertyType.arrayDimension();
        ObjectNode itemResult = result = this.nf.objectNode();
        for (int i = 0; i < arrayDimension; ++i) {
            itemResult.put("type", "array");
            MinimumItems minimumItems = this.selectVersion(crApiVersion, property, MinimumItems.class);
            if (minimumItems != null) {
                result.put("minItems", minimumItems.value());
            }
            itemResult = itemResult.putObject("items");
        }
        Class<?> elementType = propertyType.arrayBase();
        if (String.class.equals(elementType)) {
            itemResult.put("type", "string");
        } else if (Integer.class.equals(elementType) || Integer.TYPE.equals(elementType) || Long.class.equals(elementType) || Long.TYPE.equals(elementType)) {
            itemResult.put("type", "integer");
        } else if (Map.class.equals(elementType)) {
            this.preserveUnknownFields(itemResult);
            itemResult.put("type", "object");
        } else if (elementType.isEnum()) {
            itemResult.put("type", "string");
            try {
                Method valuesMethod = elementType.getMethod("values", new Class[0]);
                itemResult.set("enum", this.enumCaseArray((Enum[])valuesMethod.invoke(null, new Object[0])));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.buildObjectSchema(crApiVersion, itemResult, elementType, true, description);
        }
        return result;
    }

    private ObjectNode buildBasicTypeSchema(AnnotatedElement element, Class type) {
        String typeName;
        ObjectNode result = this.nf.objectNode();
        Type typeAnno = element.getAnnotation(Type.class);
        if (typeAnno == null) {
            typeName = this.typeName(type);
            if (Map.class.equals((Object)type)) {
                this.preserveUnknownFields(result);
            }
        } else {
            typeName = typeAnno.value();
        }
        result.put("type", typeName);
        return result;
    }

    private void preserveUnknownFields(ObjectNode result) {
        if (this.crdApiVersion.compareTo(ApiVersion.V1) >= 0) {
            result.put("x-kubernetes-preserve-unknown-fields", true);
        }
    }

    private void addDescription(ApiVersion crApiVersion, ObjectNode result, AnnotatedElement element) {
        Description description = this.selectVersion(crApiVersion, element, Description.class);
        if (description != null) {
            result.put("description", DocGenerator.getDescription(description));
        }
    }

    private ObjectNode addSimpleTypeConstraints(ApiVersion crApiVersion, ObjectNode result, Property property) {
        Pattern first;
        Maximum maximum;
        Minimum minimum;
        Example example = property.getAnnotation(Example.class);
        if (example != null) {
            result.put("example", example.value());
        }
        if ((minimum = this.selectVersion(crApiVersion, property, Minimum.class)) != null) {
            result.put("minimum", minimum.value());
        }
        if ((maximum = this.selectVersion(crApiVersion, property, Maximum.class)) != null) {
            result.put("maximum", maximum.value());
        }
        if ((first = this.selectVersion(crApiVersion, property, Pattern.class)) != null) {
            result.put("pattern", first.value());
        }
        if (property.getType().isEnum()) {
            result.set("enum", this.enumCaseArray(property.getType().getEnumElements()));
        }
        if (property.getDeclaringClass().isAnnotationPresent(JsonTypeInfo.class) && property.getName().equals(property.getDeclaringClass().getAnnotation(JsonTypeInfo.class).property())) {
            result.set("enum", this.stringArray(Property.subtypeNames(property.getDeclaringClass())));
        }
        return result;
    }

    private <T extends Annotation> T selectVersion(ApiVersion crApiVersion, AnnotatedElement element, Class<T> cls) {
        Annotation[] wrapperAnnotation = element.getAnnotationsByType(cls);
        if (wrapperAnnotation == null) {
            return null;
        }
        this.checkDisjointVersions(element, wrapperAnnotation, cls);
        return (T)((Annotation)Arrays.stream(wrapperAnnotation).filter(element1 -> crApiVersion == null || CrdGenerator.apiVersion(element1, cls).contains(crApiVersion)).findFirst().orElse(null));
    }

    private <T> void checkDisjointVersions(AnnotatedElement annotated, T[] wrapperAnnotation, Class<T> annotationClass) {
        long distinctCount;
        long count = Arrays.stream(wrapperAnnotation).map(element -> CrdGenerator.apiVersion(element, annotationClass)).count();
        if (count != (distinctCount = Arrays.stream(wrapperAnnotation).map(element -> CrdGenerator.apiVersion(element, annotationClass)).distinct().count())) {
            this.err("Duplicate version ranges on " + annotated);
        }
        Arrays.stream(wrapperAnnotation).map(element -> CrdGenerator.apiVersion(element, annotationClass)).flatMap(x -> Arrays.stream(wrapperAnnotation).map(y -> CrdGenerator.apiVersion(y, annotationClass)).filter(y -> !y.equals(x)).map(y -> new VersionRange[]{x, y})).forEach(pair -> {
            if (pair[0].intersects(pair[1])) {
                this.err(pair[0] + " and " + pair[1] + " are not disjoint on " + annotated);
            }
        });
    }

    private static <T> VersionRange<ApiVersion> apiVersion(T element, Class<T> annotationClass) {
        try {
            Method apiVersionsMethod = annotationClass.getDeclaredMethod("apiVersions", new Class[0]);
            String apiVersions = (String)apiVersionsMethod.invoke(element, new Object[0]);
            return ApiVersion.parseRange(apiVersions);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private <E extends Enum<E>> ArrayNode enumCaseArray(E[] values) {
        ArrayNode arrayNode = this.nf.arrayNode();
        arrayNode.addAll(Schema.enumCases(values));
        return arrayNode;
    }

    private String typeName(Class type) {
        if (String.class.equals((Object)type)) {
            return "string";
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type) || Long.TYPE.equals(type) || Long.class.equals((Object)type) || Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
            return "integer";
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            return "boolean";
        }
        if (Map.class.equals((Object)type)) {
            return "object";
        }
        if (List.class.equals((Object)type) || type.isArray()) {
            return "array";
        }
        if (type.isEnum()) {
            return "string";
        }
        if (Double.class.equals((Object)type) || Double.TYPE.equals(type) || Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
            return "number";
        }
        throw new RuntimeException(type.getName());
    }

    ArrayNode stringArray(Iterable<String> list) {
        ArrayNode arrayNode = this.nf.arrayNode();
        for (String sn : list) {
            arrayNode.add(sn);
        }
        return arrayNode;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        CommandOptions opts = new CommandOptions(args);
        CrdGenerator generator = new CrdGenerator(opts.targetKubeVersions, opts.crdApiVersion, opts.yaml ? YAML_MAPPER.configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true) : JSON_MATTER, opts.labels, new DefaultReporter(), opts.apiVersions, opts.storageVersion, null, opts.conversionStrategy, opts.describeVersions);
        for (Map.Entry<String, Class<? extends CustomResource>> entry : opts.classes.entrySet()) {
            File file = new File(entry.getKey());
            if (file.getParentFile().exists()) {
                if (!file.getParentFile().isDirectory()) {
                    generator.err(file.getParentFile() + " is not a directory");
                }
            } else if (!file.getParentFile().mkdirs()) {
                generator.err(file.getParentFile() + " does not exist and could not be created");
            }
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                generator.generate(entry.getValue(), w);
            }
        }
        if (generator.numErrors > 0) {
            System.err.println("There were " + generator.numErrors + " errors");
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public static interface Reporter {
        public void warn(String var1);

        public void err(String var1);
    }

    public static class DefaultReporter
    implements Reporter {
        @Override
        public void warn(String s) {
            System.err.println("CrdGenerator: warn: " + s);
        }

        @Override
        public void err(String s) {
            System.err.println("CrdGenerator: error: " + s);
        }
    }

    public static class NoneConversionStrategy
    implements ConversionStrategy {
    }

    public static interface ConversionStrategy {
    }

    public static class WebhookConversionStrategy
    implements ConversionStrategy {
        private final String url;
        private final String name;
        private final String namespace;
        private final String path;
        private final int port;
        private final String caBundle;

        public WebhookConversionStrategy(String url, String caBundle) {
            Objects.requireNonNull(url);
            Objects.requireNonNull(caBundle);
            this.url = url;
            this.name = null;
            this.namespace = null;
            this.path = null;
            this.port = -1;
            this.caBundle = caBundle;
        }

        public WebhookConversionStrategy(String name, String namespace, String path, int port, String caBundle) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(path);
            if (port <= 0) {
                throw new IllegalArgumentException();
            }
            Objects.requireNonNull(caBundle);
            this.url = null;
            this.name = name;
            this.namespace = namespace;
            this.path = path;
            this.port = port;
            this.caBundle = caBundle;
        }

        public boolean isUrl() {
            return this.url != null;
        }
    }

    static class CommandOptions {
        private boolean yaml = false;
        private final LinkedHashMap<String, String> labels = new LinkedHashMap();
        VersionRange<KubeVersion> targetKubeVersions = null;
        ApiVersion crdApiVersion = null;
        List<ApiVersion> apiVersions = null;
        VersionRange<ApiVersion> describeVersions = null;
        ApiVersion storageVersion = null;
        Map<String, Class<? extends CustomResource>> classes = new HashMap<String, Class<? extends CustomResource>>();
        private final ConversionStrategy conversionStrategy;

        public CommandOptions(String[] args) throws ClassNotFoundException, IOException {
            String conversionServiceUrl = null;
            String conversionServiceName = null;
            String conversionServiceNamespace = null;
            String conversionServicePath = null;
            int conversionServicePort = -1;
            String conversionServiceCaBundle = null;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--")) {
                    switch (arg) {
                        case "--yaml": {
                            this.yaml = true;
                            break;
                        }
                        case "--label": {
                            int index = args[++i].indexOf(":");
                            if (index == -1) {
                                CrdGenerator.argParseErr("Invalid --label " + args[i]);
                            }
                            this.labels.put(args[i].substring(0, index), args[i].substring(index + 1));
                            break;
                        }
                        case "--target-kube": {
                            if (this.targetKubeVersions != null) {
                                CrdGenerator.argParseErr("--target-kube can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--target-kube needs an argument");
                                break;
                            }
                            this.targetKubeVersions = KubeVersion.parseRange(args[++i]);
                            break;
                        }
                        case "--crd-api-version": {
                            if (this.crdApiVersion != null) {
                                CrdGenerator.argParseErr("--crd-api-version can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--crd-api-version needs an argument");
                                break;
                            }
                            this.crdApiVersion = ApiVersion.parse(args[++i]);
                            break;
                        }
                        case "--api-versions": {
                            if (this.apiVersions != null) {
                                CrdGenerator.argParseErr("--api-versions can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--api-versions needs an argument");
                                break;
                            }
                            this.apiVersions = Arrays.stream(args[++i].split(",")).map(v -> ApiVersion.parse(v)).collect(Collectors.toList());
                            break;
                        }
                        case "--describe-api-versions": {
                            if (this.describeVersions != null) {
                                CrdGenerator.argParseErr("--describe-api-versions can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--describe-api-versions needs an argument");
                                break;
                            }
                            this.describeVersions = ApiVersion.parseRange(args[++i]);
                            break;
                        }
                        case "--storage-version": {
                            if (this.storageVersion != null) {
                                CrdGenerator.argParseErr("--storage-version can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--storage-version needs an argument");
                                break;
                            }
                            this.storageVersion = ApiVersion.parse(args[++i]);
                            break;
                        }
                        case "--conversion-service-url": {
                            if (conversionServiceUrl != null) {
                                CrdGenerator.argParseErr("--conversion-service-url can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--conversion-service-url needs an argument");
                                break;
                            }
                            conversionServiceUrl = args[++i];
                            break;
                        }
                        case "--conversion-service-name": {
                            if (conversionServiceName != null) {
                                CrdGenerator.argParseErr("--conversion-service-name can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--conversion-service-name needs an argument");
                                break;
                            }
                            conversionServiceName = args[++i];
                            break;
                        }
                        case "--conversion-service-namespace": {
                            if (conversionServiceNamespace != null) {
                                CrdGenerator.argParseErr("--conversion-service-namespace can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--conversion-service-namespace needs an argument");
                                break;
                            }
                            conversionServiceNamespace = args[++i];
                            break;
                        }
                        case "--conversion-service-path": {
                            if (conversionServicePath != null) {
                                CrdGenerator.argParseErr("--conversion-service-path can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--conversion-service-path needs an argument");
                                break;
                            }
                            conversionServicePath = args[++i];
                            break;
                        }
                        case "--conversion-service-port": {
                            if (conversionServicePort > 0) {
                                CrdGenerator.argParseErr("--conversion-service-port can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--conversion-service-port needs an argument");
                                break;
                            }
                            conversionServicePort = Integer.parseInt(args[++i]);
                            break;
                        }
                        case "--conversion-service-ca-bundle": {
                            File file;
                            byte[] bundleBytes;
                            if (conversionServiceCaBundle != null) {
                                CrdGenerator.argParseErr("--conversion-service-ca-bundle can only be specified once");
                                break;
                            }
                            if (i >= arg.length() - 1) {
                                CrdGenerator.argParseErr("--conversion-service-ca-bundle needs an argument");
                                break;
                            }
                            if (!(conversionServiceCaBundle = new String(bundleBytes = Files.readAllBytes((file = new File(args[++i])).toPath()), StandardCharsets.UTF_8)).contains("-----BEGIN CERTIFICATE-----")) {
                                throw new IllegalStateException("File " + file + " given by --conversion-service-ca-bundle should be PEM encoded");
                            }
                            conversionServiceCaBundle = Base64.getEncoder().encodeToString(bundleBytes);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported command line option " + arg);
                        }
                    }
                    continue;
                }
                String className = arg.substring(0, arg.indexOf(61));
                String fileName = arg.substring(arg.indexOf(61) + 1).replace("/", File.separator);
                Class<?> cls = Class.forName(className);
                if (!CustomResource.class.equals(cls) && CustomResource.class.isAssignableFrom(cls)) {
                    this.classes.put(fileName, cls);
                    continue;
                }
                CrdGenerator.argParseErr(cls + " is not a subclass of " + CustomResource.class.getName());
            }
            if (this.targetKubeVersions == null) {
                this.targetKubeVersions = KubeVersion.V1_16_PLUS;
            }
            if (this.crdApiVersion == null) {
                this.crdApiVersion = ApiVersion.V1;
            }
            this.conversionStrategy = conversionServiceName != null ? new WebhookConversionStrategy(conversionServiceName, conversionServiceNamespace, conversionServicePath, conversionServicePort, conversionServiceCaBundle) : (conversionServiceUrl != null ? new WebhookConversionStrategy(conversionServiceUrl, conversionServiceCaBundle) : new NoneConversionStrategy());
        }
    }
}

