/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.apt.AptContext;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AttributeKey;
import io.sundr.model.Attributeable;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.Modifiers;
import io.sundr.model.Property;
import io.sundr.model.TypeRef;
import io.sundr.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class ExecutableElementToMethod
implements Function<ExecutableElement, Method> {
    private static final String NEWLINE_PATTERN = "\r|\n";
    private final AptContext context;
    private final Function<TypeMirror, TypeRef> referenceAdapterFunction;
    private final Function<VariableElement, Property> propertyAdapterFunction;
    private final Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction;

    public ExecutableElementToMethod(AptContext context, Function<TypeMirror, TypeRef> referenceAdapterFunction, Function<VariableElement, Property> propertyAdapterFunction, Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction) {
        this.context = context;
        this.referenceAdapterFunction = referenceAdapterFunction;
        this.propertyAdapterFunction = propertyAdapterFunction;
        this.annotationAdapterFunction = annotationAdapterFunction;
    }

    @Override
    public Method apply(ExecutableElement executableElement) {
        String comments;
        HashMap<AttributeKey, String> attributes = new HashMap<AttributeKey, String>();
        if (executableElement.getDefaultValue() != null && executableElement.getDefaultValue().getValue() != null) {
            Object defaultValue = executableElement.getDefaultValue().accept(new AnnotationValueVisitor(){

                public Object visit(AnnotationValue av) {
                    return String.valueOf(av);
                }

                public Object visit(AnnotationValue av, Object p) {
                    return String.valueOf(av);
                }

                public Object visitBoolean(boolean b, Object p) {
                    return String.valueOf(b);
                }

                public Object visitByte(byte b, Object p) {
                    return String.valueOf(b);
                }

                public Object visitChar(char c, Object p) {
                    return String.valueOf(c);
                }

                public Object visitDouble(double d, Object p) {
                    return String.valueOf(d);
                }

                public Object visitFloat(float f, Object p) {
                    return String.valueOf(f);
                }

                public Object visitInt(int i, Object p) {
                    return String.valueOf(i);
                }

                public Object visitLong(long i, Object p) {
                    return String.valueOf(i) + "L";
                }

                public Object visitShort(short s, Object p) {
                    return String.valueOf(s);
                }

                public Object visitString(String s, Object p) {
                    return s;
                }

                public Object visitType(TypeMirror t, Object p) {
                    return t.toString();
                }

                public Object visitEnumConstant(VariableElement c, Object p) {
                    if (c.getSimpleName().toString().contains(c.getEnclosingElement().toString())) {
                        return c.getSimpleName().toString();
                    }
                    return c.getEnclosingElement() + "." + c.getSimpleName();
                }

                public Object visitAnnotation(AnnotationMirror a, Object p) {
                    return a;
                }

                public Object visitArray(List vals, Object p) {
                    return vals;
                }

                public Object visitUnknown(AnnotationValue av, Object p) {
                    return av;
                }
            }, null);
            attributes.put(Attributeable.DEFAULT_VALUE, String.valueOf(defaultValue));
        }
        ArrayList commentList = Strings.isNullOrEmpty((String)(comments = this.context.getElements().getDocComment(executableElement))) ? new ArrayList() : Arrays.stream(comments.split(NEWLINE_PATTERN)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        MethodBuilder methodBuilder = (MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withComments(commentList)).withDefaultMethod(executableElement.isDefault())).withModifiers(Modifiers.from(executableElement.getModifiers()))).withName(executableElement.getSimpleName().toString())).withReturnType(this.referenceAdapterFunction.apply(executableElement.getReturnType()))).withVarArgPreferred(executableElement.isVarArgs())).withAttributes(attributes);
        for (VariableElement variableElement : executableElement.getParameters()) {
            methodBuilder = (MethodBuilder)methodBuilder.addToArguments(new Property[]{this.propertyAdapterFunction.apply(variableElement)});
        }
        ArrayList<ClassRef> exceptionRefs = new ArrayList<ClassRef>();
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            TypeRef thrownRef = this.referenceAdapterFunction.apply(typeMirror);
            if (thrownRef instanceof ClassRef) {
                exceptionRefs.add((ClassRef)thrownRef);
            }
            methodBuilder = (MethodBuilder)methodBuilder.withExceptions(exceptionRefs);
        }
        for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
            methodBuilder = (MethodBuilder)methodBuilder.withAnnotations(new AnnotationRef[]{this.annotationAdapterFunction.apply(annotationMirror)});
        }
        return methodBuilder.build();
    }
}

