/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.reflect;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.AttributeKey;
import io.sundr.model.Attributeable;
import io.sundr.model.ClassRef;
import io.sundr.model.Kind;
import io.sundr.model.Method;
import io.sundr.model.MethodBuilder;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefBuilder;
import io.sundr.model.TypeRef;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassToTypeDef
implements Function<Class, TypeDef> {
    private static final String ARGUMENT_PREFIX = "arg";
    private final AdapterContext context;
    private final Set<Class> references;
    private final Function<Type, TypeRef> typeToTypeRef;
    private final Function<Type, TypeParamDef> typeToTypeParamDef;
    private final Function<Class<? extends Annotation>, AnnotationRef> annotationTypeToAnnotationRef;
    private final Function<Class, Kind> classToKind;

    public ClassToTypeDef(AdapterContext context, Set<Class> references, Function<Type, TypeRef> typeToTypeRef, Function<Type, TypeParamDef> typeToTypeParamDef, Function<Class<? extends Annotation>, AnnotationRef> annotationTypeToAnnotationRef, Function<Class, Kind> classToKind) {
        this.context = context;
        this.references = references;
        this.typeToTypeRef = typeToTypeRef;
        this.typeToTypeParamDef = typeToTypeParamDef;
        this.annotationTypeToAnnotationRef = annotationTypeToAnnotationRef;
        this.classToKind = classToKind;
    }

    @Override
    public TypeDef apply(Class item) {
        if (Object.class.equals((Object)item)) {
            return TypeDef.OBJECT;
        }
        Kind kind = this.classToKind.apply(item);
        ArrayList<ClassRef> extendsList = new ArrayList<ClassRef>();
        ArrayList<ClassRef> implementsList = new ArrayList<ClassRef>();
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Method> constructors = new ArrayList<Method>();
        ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
        ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
        if (item.getSuperclass() != null) {
            extendsList.add((ClassRef)this.typeToTypeRef.apply(item.getGenericSuperclass()));
            this.references.add(item.getSuperclass());
        }
        for (Class<?> clazz : item.getInterfaces()) {
            this.references.add(clazz);
        }
        for (Type type : item.getGenericInterfaces()) {
            TypeRef ref = this.typeToTypeRef.apply(type);
            if (!(ref instanceof ClassRef)) continue;
            implementsList.add((ClassRef)ref);
        }
        constructors.addAll(this.getConstructors(item, this.references));
        methods.addAll(this.getMethods(item, this.references));
        properties.addAll(this.getProperties(item, this.references));
        annotationRefs.addAll(this.getAnnotations(item));
        for (Type type : item.getTypeParameters()) {
            ArrayList<ClassRef> bounds = new ArrayList<ClassRef>();
            for (Type boundType : type.getBounds()) {
                TypeRef typeRef = this.typeToTypeRef.apply(boundType);
                if (!(typeRef instanceof ClassRef)) continue;
                bounds.add((ClassRef)typeRef);
            }
            parameters.add(((TypeParamDefBuilder)((TypeParamDefBuilder)new TypeParamDefBuilder().withName(type.getName())).withBounds(bounds)).build());
        }
        String outerFQCN = item.getDeclaringClass() != null ? item.getDeclaringClass().getName() : null;
        TypeDef result = this.context.getDefinitionRepository().register(((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withKind(kind)).withOuterTypeName(outerFQCN)).withName(item.getSimpleName())).withPackageName(item.getPackage() != null ? item.getPackage().getName() : null)).withModifiers(item.getModifiers())).withParameters(parameters)).withConstructors(constructors)).withMethods(methods)).withProperties(properties)).withExtendsList(extendsList)).withImplementsList(implementsList)).withAnnotations(annotationRefs)).build());
        HashSet<Class> copy = new HashSet<Class>(this.references);
        copy.stream().peek(c -> this.references.remove(c)).filter(c -> !c.equals(item)).filter(c -> !c.getName().startsWith("sun.") && !c.getName().toString().startsWith("com.sun.")).forEach(c -> {
            String referenceFQCN = c.getName().replaceAll(Pattern.quote("$"), ".");
            this.context.getDefinitionRepository().registerIfAbsent(referenceFQCN, () -> this.apply((Class)c));
        });
        return result;
    }

    private List<AnnotationRef> getAnnotations(Class item) {
        ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
        this.processAnnotatedElement(item, annotationRefs);
        return annotationRefs;
    }

    private Set<Property> getProperties(Class item, Set<Class> references) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Field field : item.getDeclaredFields()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            this.processAnnotatedElement(field, annotationRefs);
            if (field.getGenericType() instanceof Class) {
                references.add((Class)field.getGenericType());
            }
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)field.getGenericType();
                references.addAll(Stream.of(p.getActualTypeArguments()).filter(t -> t instanceof Class).map(t -> (Class)t).filter(c -> !item.equals(c)).collect(Collectors.toList()));
            }
            properties.add(((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(field.getName())).withModifiers(field.getModifiers())).withAnnotations(annotationRefs)).withTypeRef(this.typeToTypeRef.apply(field.getGenericType()))).build());
        }
        return properties;
    }

    private Set<Method> getConstructors(Class item, Set<Class> references) {
        HashSet<Method> constructors = new HashSet<Method>();
        for (Constructor<?> constructor : item.getDeclaredConstructors()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            ArrayList<ClassRef> exceptionRefs = new ArrayList<ClassRef>();
            ArrayList<Property> arguments = new ArrayList<Property>();
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            this.processMethod(references, constructor, annotationRefs, exceptionRefs, arguments, parameters);
            constructors.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(constructor.getName())).withModifiers(constructor.getModifiers())).withArguments(arguments)).withParameters(parameters)).withAnnotations(annotationRefs)).withExceptions(exceptionRefs)).build());
        }
        return constructors;
    }

    private Set<Method> getMethods(Class item, Set<Class> references) {
        HashSet<Method> methods = new HashSet<Method>();
        for (java.lang.reflect.Method method : item.getDeclaredMethods()) {
            ArrayList<AnnotationRef> annotationRefs = new ArrayList<AnnotationRef>();
            ArrayList<ClassRef> exceptionRefs = new ArrayList<ClassRef>();
            ArrayList<Property> arguments = new ArrayList<Property>();
            ArrayList<TypeParamDef> parameters = new ArrayList<TypeParamDef>();
            this.processMethod(references, method, annotationRefs, exceptionRefs, arguments, parameters);
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>();
            if (method.getDefaultValue() != null) {
                attributes.put(Attributeable.DEFAULT_VALUE, method.getDefaultValue());
            }
            methods.add(((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)((MethodBuilder)new MethodBuilder().withName(method.getName())).withDefaultMethod(method.isDefault())).withModifiers(method.getModifiers())).withReturnType(this.typeToTypeRef.apply(method.getGenericReturnType()))).withArguments(arguments)).withParameters(parameters)).withExceptions(exceptionRefs)).withAnnotations(annotationRefs)).withAttributes(attributes)).build());
        }
        return methods;
    }

    private void processAnnotatedElement(AnnotatedElement element, List<AnnotationRef> annotationRefs) {
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            AnnotationRef annotationRef = this.annotationTypeToAnnotationRef.apply(annotationType);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (java.lang.reflect.Method method : annotationType.getDeclaredMethods()) {
                String name = method.getName();
                try {
                    Object value = method.invoke((Object)annotation, (Object[])null);
                    parameters.put(name, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (annotationType.getName().startsWith("jdk.")) continue;
                    System.out.printf("Couldn't retrieve '%s' parameter value for %s%n", name, annotationType.getName());
                }
            }
            annotationRef = ((AnnotationRefBuilder)new AnnotationRefBuilder(annotationRef).withParameters(parameters)).build();
            annotationRefs.add(annotationRef);
        }
    }

    private void processMethod(Set<Class> references, Executable method, List<AnnotationRef> annotationRefs, List<ClassRef> exceptionRefs, List<Property> arguments, List<TypeParamDef> parameters) {
        this.processAnnotatedElement(method, annotationRefs);
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            exceptionRefs.add((ClassRef)this.typeToTypeRef.apply(exceptionType));
        }
        for (int i = 1; i <= method.getGenericParameterTypes().length; ++i) {
            Type argumentType = method.getGenericParameterTypes()[i - 1];
            arguments.add(((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withName(ARGUMENT_PREFIX + i)).withTypeRef(this.typeToTypeRef.apply(argumentType))).build());
            if (!(argumentType instanceof Class)) continue;
            references.add((Class)argumentType);
        }
        for (Type type : method.getGenericParameterTypes()) {
            TypeParamDef typeParamDef = this.typeToTypeParamDef.apply(type);
            if (typeParamDef == null) continue;
            parameters.add(typeParamDef);
        }
    }
}

