/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.generator;

import io.sundr.codegen.directives.ClassDirective;
import io.sundr.codegen.directives.FieldDirective;
import io.sundr.codegen.directives.MethodDirective;
import io.sundr.codegen.generator.GeneratorUtils;
import java.io.Writer;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class CodeGenerator<M> {
    private final VelocityContext context;
    private final Writer writer;
    private final M model;
    private final String templateResource;
    private final Template template;
    private final Set<Class<? extends Directive>> directives;

    public CodeGenerator(M model, Writer writer, String templateResource, Set<Class<? extends Directive>> directives) {
        this.model = model;
        this.writer = writer;
        this.templateResource = templateResource;
        this.context = new VelocityContext();
        this.directives = directives;
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        engine.loadDirective(ClassDirective.class.getCanonicalName());
        engine.loadDirective(MethodDirective.class.getCanonicalName());
        engine.loadDirective(FieldDirective.class.getCanonicalName());
        for (Class<? extends Directive> directive : directives) {
            engine.loadDirective(directive.getCanonicalName());
        }
        this.template = engine.getTemplate(templateResource);
        this.context.put("model", model);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public M getModel() {
        return this.model;
    }

    public String getTemplateResource() {
        return this.templateResource;
    }

    public Set<Class<? extends Directive>> getDirectives() {
        return this.directives;
    }

    public void generate() {
        GeneratorUtils.generate(this.context, this.writer, this.template);
    }
}

